#
# TABLE STRUCTURE FOR: attendence_type
#

DROP TABLE IF EXISTS `attendence_type`;

CREATE TABLE `attendence_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `key_value` varchar(50) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'yes', '2016-06-23 14:11:37', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Late With Excuse', '<b class=\"text text-warning\">E</b>', 'no', '2018-05-29 04:19:48', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Late', '<b class=\"text text-warning\">L</b>', 'yes', '2016-06-23 14:12:28', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Absent', '<b class=\"text text-danger\">A</b>', 'yes', '2016-10-11 07:35:40', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'yes', '2016-10-11 07:35:01', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Half Day', '<b class=\"text text-warning\">F</b>', 'yes', '2016-06-23 14:12:28', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `book_id` int(11) DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `is_returned` int(11) DEFAULT 0,
  `member_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: books
#

DROP TABLE IF EXISTS `books`;

CREATE TABLE `books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_title` varchar(100) NOT NULL,
  `book_no` varchar(50) NOT NULL,
  `isbn_no` varchar(100) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `rack_no` varchar(100) NOT NULL,
  `publish` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `perunitcost` float(10,2) DEFAULT NULL,
  `postdate` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `available` varchar(10) DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: categories
#

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Nursery', 'no', '2022-11-24 02:47:11', '0000-00-00 00:00:00');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Primary', 'no', '2022-11-24 02:46:54', '0000-00-00 00:00:00');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Secondary', 'no', '2022-11-24 02:47:02', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = students',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_student_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`) VALUES (1, 'Sample Transfer Certificate', 'This is certify that <b>[name]</b> has born on [dob]  <br> and have following details [present_address] [guardian] [created_at] [admission_no] [roll_no] [class] [section] [gender] [admission_date] [category] [cast] [father_name] [mother_name] [religion] [email] [phone] .<br>We wish best of luck for future endeavors.', 'Reff. No.......................', '', 'Date: ___/____/_______', '.................................<br>Authority Sign', '.................................<br>Principal Sign', '.................................<br>Class Teacher Sign', 'sampletc12.png', '2018-09-05 15:47:33', '0000-00-00 00:00:00', 2, 1, 360, 400, 480, 810, 1, 230);


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_student_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_student_id` (`create_student_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: class_sections
#

DROP TABLE IF EXISTS `class_sections`;

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 'no', '2022-11-24 04:57:21', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 2, 1, 'no', '2022-11-24 04:57:56', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 3, 1, 'no', '2022-11-24 04:58:07', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 4, 1, 'no', '2022-11-24 04:58:23', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (5, 5, 1, 'no', '2022-11-24 04:59:00', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 6, 1, 'no', '2022-11-24 04:59:11', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (7, 7, 1, 'no', '2022-11-24 04:59:24', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (8, 8, 1, 'no', '2022-11-24 04:59:34', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (9, 9, 1, 'no', '2022-11-24 04:59:48', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (10, 10, 1, 'no', '2022-11-24 04:59:57', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (11, 11, 1, 'no', '2022-11-24 05:00:05', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (12, 12, 1, 'no', '2022-11-24 05:00:20', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (13, 13, 1, 'no', '2022-11-24 05:00:27', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (14, 14, 1, 'no', '2022-12-02 07:28:30', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: class_teacher
#

DROP TABLE IF EXISTS `class_teacher`;

CREATE TABLE `class_teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (1, 10, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (2, 11, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (3, 13, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (4, 1, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (5, 2, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (6, 3, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (7, 4, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (8, 5, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (9, 6, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (10, 7, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (11, 8, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (12, 14, 2, 1);


#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'PG', 'no', '2022-11-24 04:57:21', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'NURSERY 1', 'no', '2022-11-24 04:58:39', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'NURSERY 2', 'no', '2022-11-24 04:58:31', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'PRIMARY 1', 'no', '2022-11-24 04:58:23', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'PRIMARY 2', 'no', '2022-11-24 04:59:00', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'PRIMARY 3', 'no', '2022-11-24 04:59:11', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'PRIMARY 4', 'no', '2022-11-24 04:59:24', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'PRIMARY 5', 'no', '2022-11-24 04:59:34', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'PRIMARY 6', 'no', '2022-11-24 04:59:48', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'JSS 1', 'no', '2022-11-24 05:00:12', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'JSS 2', 'no', '2022-11-24 05:00:05', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'JSS 3', 'no', '2022-11-24 05:00:20', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'SS 1', 'no', '2022-11-24 05:00:27', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'NURSERY 3', 'no', '2022-12-09 07:54:46', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(15) NOT NULL,
  `source` varchar(15) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) NOT NULL,
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'EXAMINATION MANAGEMENT', 'yes');


#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` varchar(20) NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `is_active`, `created_at`) VALUES (1, 'sendmail', '', '', '', '', '', '', '2017-12-04 17:33:22');


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` mediumtext NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` mediumtext NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` varchar(100) NOT NULL,
  `class` int(11) NOT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` varchar(300) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_ca_label
#

DROP TABLE IF EXISTS `exam_ca_label`;

CREATE TABLE `exam_ca_label` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `ca_type` varchar(10) NOT NULL,
  `max_mark` varchar(10) NOT NULL,
  `label` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `active` int(1) NOT NULL,
  `last_modified` timestamp NOT NULL DEFAULT current_timestamp(),
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: exam_result_label
#

DROP TABLE IF EXISTS `exam_result_label`;

CREATE TABLE `exam_result_label` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `head_address` varchar(60) DEFAULT NULL,
  `teacher_address` varchar(60) DEFAULT NULL,
  `student_address` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: exam_results
#

DROP TABLE IF EXISTS `exam_results`;

CREATE TABLE `exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attendence` varchar(10) NOT NULL,
  `exam_schedule_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `ca1` float(10,2) DEFAULT NULL,
  `ca2` float(10,2) DEFAULT NULL,
  `ca3` float(10,2) DEFAULT NULL,
  `ca4` float(10,2) DEFAULT NULL,
  `ca5` float(10,2) DEFAULT NULL,
  `ca6` float(10,2) DEFAULT NULL,
  `ca7` float(10,2) DEFAULT NULL,
  `ca8` float(10,2) DEFAULT NULL,
  `ca9` float(10,2) DEFAULT NULL,
  `get_marks` float(10,2) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `exam_schedule_id` (`exam_schedule_id`),
  KEY `student_id` (`student_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_results_character
#

DROP TABLE IF EXISTS `exam_results_character`;

CREATE TABLE `exam_results_character` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `exam_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `c1` int(11) DEFAULT NULL,
  `c2` int(11) DEFAULT NULL,
  `c3` int(11) DEFAULT NULL,
  `c4` int(11) DEFAULT NULL,
  `c5` int(11) DEFAULT NULL,
  `c6` int(11) DEFAULT NULL,
  `c7` int(11) DEFAULT NULL,
  `c8` int(11) DEFAULT NULL,
  `c9` int(11) DEFAULT NULL,
  `c10` int(11) DEFAULT NULL,
  `c11` int(11) DEFAULT NULL,
  `c12` int(11) DEFAULT NULL,
  `c13` int(11) DEFAULT NULL,
  `c14` int(11) DEFAULT NULL,
  `c15` int(11) DEFAULT NULL,
  `c16` int(11) DEFAULT NULL,
  `c17` int(11) DEFAULT NULL,
  `c18` int(11) DEFAULT NULL,
  `c19` int(11) DEFAULT NULL,
  `c20` int(11) DEFAULT NULL,
  `c21` int(11) DEFAULT NULL,
  `c22` int(11) DEFAULT NULL,
  `c23` int(11) DEFAULT NULL,
  `c24` int(11) DEFAULT NULL,
  `c25` int(11) DEFAULT NULL,
  `c26` int(11) DEFAULT NULL,
  `c27` int(11) DEFAULT NULL,
  `c28` int(11) DEFAULT NULL,
  `c29` int(11) DEFAULT NULL,
  `c30` int(11) DEFAULT NULL,
  `c31` int(11) DEFAULT NULL,
  `c32` int(11) DEFAULT NULL,
  `c33` int(11) DEFAULT NULL,
  `c34` int(11) DEFAULT NULL,
  `c35` int(11) DEFAULT NULL,
  `c36` int(11) DEFAULT NULL,
  `c37` int(11) DEFAULT NULL,
  `c38` int(11) DEFAULT NULL,
  `c39` int(11) DEFAULT NULL,
  `c40` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `exam_schedule_id` (`exam_id`),
  KEY `student_id` (`student_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: exam_results_comment
#

DROP TABLE IF EXISTS `exam_results_comment`;

CREATE TABLE `exam_results_comment` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `session` varchar(200) NOT NULL,
  `exam_id` varchar(100) NOT NULL,
  `student_id` varchar(100) NOT NULL,
  `teacher_comment` varchar(200) DEFAULT NULL,
  `head_comment` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (1, '2021-22', '1', '150', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (2, '2021-22', '1', '164', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (3, '2021-22', '1', '167', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (4, '2021-22', '1', '175', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (5, '2021-22', '1', '181', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (6, '2021-22', '1', '208', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (7, '2021-22', 'ANNUAL', '150', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (8, '2021-22', 'ANNUAL', '164', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (9, '2021-22', 'ANNUAL', '167', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (10, '2021-22', 'ANNUAL', '175', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (11, '2021-22', 'ANNUAL', '181', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (12, '2021-22', 'ANNUAL', '208', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (13, '2021-22', '1', '151', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (14, '2021-22', '1', '152', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (15, '2021-22', '1', '153', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (16, '2021-22', '1', '154', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (17, '2021-22', '1', '156', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (18, '2021-22', '1', '157', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (19, '2021-22', '1', '159', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (20, '2021-22', '1', '160', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (21, '2021-22', '1', '161', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (22, '2021-22', '1', '163', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (23, '2021-22', '1', '166', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (24, '2021-22', '1', '168', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (25, '2021-22', '1', '170', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (26, '2021-22', '1', '171', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (27, '2021-22', '1', '172', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (28, '2021-22', '1', '173', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (29, '2021-22', '1', '174', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (30, '2021-22', '1', '177', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (31, '2021-22', '1', '178', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (32, '2021-22', '1', '179', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (33, '2021-22', '1', '180', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (34, '2021-22', '1', '182', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (35, '2021-22', '1', '183', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (36, '2021-22', '1', '185', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (37, '2021-22', 'ANNUAL', '151', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (38, '2021-22', 'ANNUAL', '152', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (39, '2021-22', 'ANNUAL', '153', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (40, '2021-22', 'ANNUAL', '154', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (41, '2021-22', 'ANNUAL', '156', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (42, '2021-22', 'ANNUAL', '157', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (43, '2021-22', 'ANNUAL', '159', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (44, '2021-22', 'ANNUAL', '160', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (45, '2021-22', 'ANNUAL', '161', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (46, '2021-22', 'ANNUAL', '163', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (47, '2021-22', 'ANNUAL', '166', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (48, '2021-22', 'ANNUAL', '168', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (49, '2021-22', 'ANNUAL', '170', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (50, '2021-22', 'ANNUAL', '171', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (51, '2021-22', 'ANNUAL', '172', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (52, '2021-22', 'ANNUAL', '173', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (53, '2021-22', 'ANNUAL', '174', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (54, '2021-22', 'ANNUAL', '177', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (55, '2021-22', 'ANNUAL', '178', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (56, '2021-22', 'ANNUAL', '179', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (57, '2021-22', 'ANNUAL', '180', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (58, '2021-22', 'ANNUAL', '182', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (59, '2021-22', 'ANNUAL', '183', NULL, NULL);
INSERT INTO `exam_results_comment` (`id`, `session`, `exam_id`, `student_id`, `teacher_comment`, `head_comment`) VALUES (60, '2021-22', 'ANNUAL', '185', NULL, NULL);


#
# TABLE STRUCTURE FOR: exam_schedules
#

DROP TABLE IF EXISTS `exam_schedules`;

CREATE TABLE `exam_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `exam_id` int(11) DEFAULT NULL,
  `teacher_subject_id` int(11) DEFAULT NULL,
  `date_of_exam` date DEFAULT NULL,
  `start_to` varchar(50) DEFAULT NULL,
  `end_from` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `full_marks` int(11) DEFAULT NULL,
  `passing_marks` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `teacher_subject_id` (`teacher_subject_id`)
) ENGINE=InnoDB AUTO_INCREMENT=138 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1, 16, 1, 1, '2022-11-16', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2, 16, 1, 2, '2022-11-17', '09:00 AM', '12:00 PM', 'classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (3, 16, 1, 3, '2022-12-19', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (4, 16, 1, 4, '2022-11-21', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (5, 16, 1, 5, '2022-11-22', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (6, 16, 1, 6, '2022-11-23', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (7, 16, 1, 7, '2022-12-23', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (8, 16, 1, 8, '2022-12-26', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (9, 16, 1, 9, '2022-12-27', '09:00 AM', '12:00 PM', 'Classoom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (10, 16, 1, 10, '2022-12-27', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (11, 16, 1, 11, '2022-12-28', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (12, 16, 1, 12, '2022-12-29', '09:00 AM', '12:00 PM', 'Classroom', 100, 30, NULL, 'no', '2022-12-09 22:55:54', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (13, 16, 1, 25, '2022-11-16', '09:00 AM', '12:15 PM', 'Clasrooom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (14, 16, 1, 26, '2022-11-17', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (15, 16, 1, 27, '2022-11-18', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (16, 16, 1, 28, '2022-11-21', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (17, 16, 1, 29, '2022-11-22', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (18, 16, 1, 30, '2022-11-23', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (19, 16, 1, 31, '2022-12-26', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (20, 16, 1, 32, '2022-12-27', '09:00 AM', '12:00 PM', 'Cllassroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (21, 16, 1, 33, '2022-12-28', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (22, 16, 1, 34, '2022-12-29', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (23, 16, 1, 35, '2022-12-29', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (24, 16, 1, 36, '2022-12-30', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:42:03', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (25, 16, 1, 37, '2022-11-16', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (26, 16, 1, 38, '2022-11-17', '09:00 AM', '12:00 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (27, 16, 1, 39, '2022-11-18', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (28, 16, 1, 40, '2022-11-21', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (29, 16, 1, 42, '2022-11-22', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (30, 16, 1, 43, '2022-12-23', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (31, 16, 1, 44, '2022-12-26', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (32, 16, 1, 45, '2022-12-27', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (33, 16, 1, 46, '2022-12-27', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (34, 16, 1, 47, '2022-11-28', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (35, 16, 1, 48, '2022-12-29', '09:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (36, 16, 1, 49, '2022-12-30', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:36:26', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (37, 16, 1, 50, '2022-11-21', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (38, 16, 1, 51, '2022-11-22', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (39, 16, 1, 52, '2022-11-23', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (40, 16, 1, 53, '2022-11-24', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (41, 16, 1, 54, '2022-11-25', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (42, 16, 1, 55, '2022-11-28', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (43, 16, 1, 56, '2022-11-29', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (44, 16, 1, 57, '2022-11-30', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (45, 16, 1, 58, '2022-12-01', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (46, 16, 1, 59, '2022-12-02', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (47, 16, 1, 60, '2022-12-05', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (48, 16, 1, 61, '2022-12-06', '12:00 AM', '09:00 AM', 'Classroom', 70, 30, NULL, 'no', '2022-12-09 12:13:36', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (49, 16, 1, 62, '2022-11-21', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (50, 16, 1, 63, '2022-11-22', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (51, 16, 1, 64, '2022-11-23', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (52, 16, 1, 65, '2022-11-24', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (53, 16, 1, 66, '2022-11-25', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (54, 16, 1, 67, '2022-11-28', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (55, 16, 1, 68, '2022-11-29', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (56, 16, 1, 69, '2022-11-30', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (57, 16, 1, 70, '2022-12-01', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (58, 16, 1, 71, '2022-12-02', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (59, 16, 1, 72, '2022-12-05', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (60, 16, 1, 73, '2022-12-06', '09:00 AM', '12:00 PM', 'classroom', 100, 40, NULL, 'no', '2022-12-09 12:30:41', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (61, 16, 1, 13, '2022-11-16', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (62, 16, 1, 14, '2022-11-17', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (63, 16, 1, 15, '2022-11-18', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (64, 16, 1, 16, '2022-11-21', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (65, 16, 1, 17, '2022-11-22', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (66, 16, 1, 18, '2022-11-23', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (67, 16, 1, 19, '2022-11-24', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (68, 16, 1, 20, '2022-11-25', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (69, 16, 1, 21, '2022-11-28', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (70, 16, 1, 22, '2022-12-29', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (71, 16, 1, 23, '2022-11-30', '09:00 AM', '12:00 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (72, 16, 1, 24, '2022-12-01', '09:00 AM', '12:00 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 12:51:28', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (73, 16, 1, 74, '2022-11-21', '09:00 AM', '12:30 PM', 'Classrroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (74, 16, 1, 75, '2022-11-22', '09:00 AM', '02:15 PM', 'ciassroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (75, 16, 1, 76, '2022-11-23', '09:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (76, 16, 1, 77, '2022-12-26', '09:00 AM', '11:15 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (77, 16, 1, 78, '2022-12-27', '09:00 AM', '11:15 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (78, 16, 1, 79, '2022-12-28', '09:15 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (79, 16, 1, 80, '2022-11-29', '12:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (80, 16, 1, 81, '2022-11-30', '09:00 AM', '12:15 PM', 'Classsroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (81, 16, 1, 82, '2022-12-01', '01:00 PM', '02:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (82, 16, 1, 83, '2022-12-02', '11:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (83, 16, 1, 84, '2022-12-05', '11:30 AM', '01:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (84, 16, 1, 85, '2022-12-06', '12:00 AM', '10:15 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:42:57', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (85, 16, 1, 86, '2022-11-21', '09:00 AM', '01:30 PM', 'classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (86, 16, 1, 87, '2022-11-22', '10:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (87, 16, 1, 88, '2022-11-23', '09:00 AM', '01:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (88, 16, 1, 89, '2022-11-24', '12:00 AM', '10:30 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (89, 16, 1, 90, '2022-11-25', '09:00 AM', '12:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (90, 16, 1, 91, '2022-11-28', '10:00 AM', '01:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (91, 16, 1, 92, '2022-11-29', '09:00 AM', '01:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (92, 16, 1, 93, '2022-11-30', '09:00 AM', '01:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (93, 16, 1, 94, '2022-12-01', '09:00 AM', '01:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (94, 16, 1, 95, '2022-12-02', '03:00 AM', '01:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (95, 16, 1, 96, '2022-12-05', '09:00 AM', '01:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (96, 16, 1, 97, '2022-12-06', '09:00 AM', '01:30 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 13:51:49', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (97, 16, 1, 110, '2022-11-23', '09:00 AM', '11:45 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (98, 16, 1, 111, '2022-11-24', '10:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (99, 16, 1, 112, '2022-11-25', '12:00 AM', '10:45 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (100, 16, 1, 113, '2022-11-28', '10:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (101, 16, 1, 114, '2022-11-29', '09:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (102, 16, 1, 115, '2022-11-30', '09:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (103, 16, 1, 116, '2022-12-01', '09:00 AM', '11:45 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (104, 16, 1, 117, '2022-12-02', '10:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (105, 16, 1, 118, '2022-12-05', '09:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (106, 16, 1, 119, '2022-12-06', '09:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (107, 16, 1, 120, '2022-12-08', '10:00 AM', '12:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (108, 16, 1, 121, '2022-12-08', '08:00 AM', '11:45 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (109, 16, 1, 122, '2022-12-09', '10:00 AM', '12:45 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:03:13', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (110, 16, 1, 123, '2022-11-21', '10:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (111, 16, 1, 124, '2022-11-22', '11:00 AM', '01:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (112, 16, 1, 125, '2022-11-23', '10:00 AM', '11:00 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (113, 16, 1, 126, '2022-11-24', '12:00 PM', '01:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (114, 16, 1, 127, '2022-11-25', '10:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (115, 16, 1, 128, '2022-11-28', '10:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (116, 16, 1, 129, '2022-11-29', '12:00 AM', '11:00 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (117, 16, 1, 130, '2022-11-30', '10:00 AM', '12:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (118, 16, 1, 131, '2022-12-01', '12:00 AM', '11:00 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (119, 16, 1, 132, '2022-12-02', '11:00 AM', '01:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (120, 16, 1, 133, '2022-12-05', '11:00 AM', '01:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (121, 16, 1, 134, '2022-12-06', '11:00 AM', '12:15 PM', 'Classsroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (122, 16, 1, 135, '2022-12-07', '10:00 AM', '01:00 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 14:16:00', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (123, 16, 1, 149, '2022-11-21', '09:00 AM', '01:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (124, 16, 1, 150, '2022-11-22', '10:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (125, 16, 1, 151, '2022-11-23', '10:00 AM', '12:15 AM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (126, 16, 1, 152, '2022-11-24', '10:00 AM', '01:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (127, 16, 1, 153, '2022-11-25', '11:00 AM', '01:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (128, 16, 1, 154, '2022-11-25', '11:00 AM', '01:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (129, 16, 1, 155, '2022-11-28', '10:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (130, 16, 1, 156, '2022-11-29', '10:00 AM', '11:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (131, 16, 1, 157, '2022-11-30', '10:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (132, 16, 1, 158, '2022-12-01', '10:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (133, 16, 1, 159, '2022-12-02', '12:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (134, 16, 1, 160, '2022-12-02', '11:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (135, 16, 1, 161, '2022-12-05', '10:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (136, 16, 1, 162, '2022-12-06', '12:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');
INSERT INTO `exam_schedules` (`id`, `session_id`, `exam_id`, `teacher_subject_id`, `date_of_exam`, `start_to`, `end_from`, `room_no`, `full_marks`, `passing_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (137, 16, 1, 163, '2022-12-07', '09:00 AM', '12:15 PM', 'Classroom', 100, 40, NULL, 'no', '2022-12-09 22:31:10', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: exam_settings
#

DROP TABLE IF EXISTS `exam_settings`;

CREATE TABLE `exam_settings` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `session` varchar(20) NOT NULL,
  `exam_id` varchar(20) NOT NULL,
  `term_started` varchar(20) NOT NULL,
  `term_ended` varchar(20) NOT NULL,
  `next_begin` varchar(20) NOT NULL,
  `foot_note` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `exam_settings` (`id`, `session`, `exam_id`, `term_started`, `term_ended`, `next_begin`, `foot_note`) VALUES (1, '2021-22', '1', '', '', '', '');


#
# TABLE STRUCTURE FOR: exams
#

DROP TABLE IF EXISTS `exams`;

CREATE TABLE `exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `sesion_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exams` (`id`, `name`, `sesion_id`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'FIRST TERM', 0, 'First Term Examination', 'no', '2019-03-11 13:54:39', '0000-00-00 00:00:00');
INSERT INTO `exams` (`id`, `name`, `sesion_id`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'SECOND TERM', 0, 'Second Term Examination', 'no', '2019-03-11 13:55:07', '0000-00-00 00:00:00');
INSERT INTO `exams` (`id`, `name`, `sesion_id`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'THIRD TERM', 0, 'Third Term Examination', 'no', '2019-03-11 13:55:31', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fee_groups
#

DROP TABLE IF EXISTS `fee_groups`;

CREATE TABLE `fee_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fee_groups_feetype
#

DROP TABLE IF EXISTS `fee_groups_feetype`;

CREATE TABLE `fee_groups_feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_session_group_id` int(11) DEFAULT NULL,
  `fee_groups_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_session_group_id` (`fee_session_group_id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fee_receipt_no
#

DROP TABLE IF EXISTS `fee_receipt_no`;

CREATE TABLE `fee_receipt_no` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fee_session_groups
#

DROP TABLE IF EXISTS `fee_session_groups`;

CREATE TABLE `fee_session_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_groups_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: feecategory
#

DROP TABLE IF EXISTS `feecategory`;

CREATE TABLE `feecategory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(50) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: feemasters
#

DROP TABLE IF EXISTS `feemasters`;

CREATE TABLE `feemasters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fees_discounts
#

DROP TABLE IF EXISTS `fees_discounts`;

CREATE TABLE `fees_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: feetype
#

DROP TABLE IF EXISTS `feetype`;

CREATE TABLE `feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `feecategory_id` int(11) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `created_at`, `file_type`, `file_size`, `vid_url`, `vid_title`) VALUES (2, NULL, 'uploads/gallery/media/thumb/', 'uploads/gallery/media/', 'kids-graduation.png', 'kids-graduation.png', '2022-11-18 06:56:47', 'image/png', '1260681', '', '');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `created_at`, `file_type`, `file_size`, `vid_url`, `vid_title`) VALUES (3, NULL, 'uploads/gallery/media/thumb/', 'uploads/gallery/media/', '1200px-GNOME_Web_logo--2018.svg.png', '1200px-GNOME_Web_logo--2018.svg.png', '2022-11-18 07:15:56', 'image/png', '18682', '', '');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `created_at`, `file_type`, `file_size`, `vid_url`, `vid_title`) VALUES (4, NULL, 'uploads/gallery/media/thumb/', 'uploads/gallery/media/', 'destinyinternationalschools.sch.ng.png', 'destinyinternationalschools.sch.ng.png', '2022-11-18 07:41:17', 'image/png', '27214', '', '');


#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home', 1, 0, NULL, 'no', '2022-11-18 07:38:54');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 2, 'News', 2, 0, NULL, NULL, NULL, 'news', 4, 0, NULL, 'no', '2022-11-18 07:38:57');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'About', 3, 0, NULL, NULL, NULL, 'about', 2, 0, NULL, 'no', '2022-11-18 07:38:54');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (5, 2, 'Complain', 20, 0, NULL, NULL, NULL, 'complain', 5, 0, NULL, 'no', '2022-11-18 07:38:57');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (6, 2, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', 6, 0, NULL, 'no', '2022-11-18 07:38:57');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (7, 2, 'Gallery', 77, 0, NULL, NULL, NULL, 'gallery', 3, 0, NULL, 'no', '2022-11-18 07:38:57');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext NOT NULL,
  `ext_url_link` mediumtext NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Main Menu', 'main-menu', '', 0, '', '', 0, 'manual', 'no', '2022-11-18 07:22:11');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (3, 'Bottom Menu', 'bottom-menu', '', 0, '', '', 0, 'manual', 'no', '2022-11-18 07:22:35');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_page_contents` (`id`, `page_id`, `content_type`, `created_at`) VALUES (1, 1, 'notice', '2022-11-18 07:17:33');
INSERT INTO `front_cms_page_contents` (`id`, `page_id`, `content_type`, `created_at`) VALUES (2, 2, 'notice', '2022-11-18 07:31:53');
INSERT INTO `front_cms_page_contents` (`id`, `page_id`, `content_type`, `created_at`) VALUES (3, 77, 'gallery', '2022-11-18 07:38:19');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date NOT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>Destiny International Academy</p>', '0000-00-00', 1, 1, 'no', '2022-11-10 11:22:03');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'manual', 0, 'NEWS', 'page/news', 'page', 'news', '', '', '', '', '<title></title>\r\n<p>Our News</p>', '0000-00-00', 0, 1, 'no', '2022-11-18 07:31:53');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'manual', 0, 'ABOUT', 'page/about', 'page', 'about', '', '', '', '', '<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body>\r\n<p>About <span class=\"sidebar-session\" href=\"https://destinyinternationalschools.sch.ng/admin/front/page/create#\">DESTINY INTERNATIONAL SCHOOLS</span></p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2022-11-18 07:33:14');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (20, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<p>\r\n[form-builder:complain]</p>', '0000-00-00', 1, 1, 'no', '2018-05-09 15:14:34');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (54, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 14:46:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (76, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<title></title>\r\n<section class=\"contact\">\r\n<div class=\"container spacet50 spaceb50\">\r\n<div class=\"row\">\r\n<div class=\"col-md-12 col-sm-12\">[form-builder:contact_us]<!--./row--></div>\r\n<!--./col-md-12--></div>\r\n<!--./row--></div>\r\n<!--./container--></section>', '0000-00-00', 0, NULL, 'no', '2018-07-11 18:03:41');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (77, 'manual', 0, 'Gallery', 'page/gallery', 'page', 'gallery', '', '', '', '', '<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body>\r\n<p>Our Media Gallery</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2022-11-18 07:38:19');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (2, 1, 2, '2022-11-18 06:57:21');
INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (3, 3, 2, '2022-11-18 07:40:22');


#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `meta_title` mediumtext NOT NULL,
  `meta_description` mediumtext NOT NULL,
  `meta_keyword` mediumtext NOT NULL,
  `feature_image` mediumtext NOT NULL,
  `publish_date` date NOT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (1, 'banner', NULL, NULL, 'Banner Images', NULL, NULL, NULL, NULL, NULL, 'no', '2022-11-18 06:51:04', '', '', '', '', '0000-00-00', '0', 0);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (2, 'notice', 'our-officicial-website', 'read/our-officicial-website', 'Our Officicial Website', '2022-11-18', NULL, NULL, NULL, '<p>It&#39;s our pleasure to announce to you that we have our official website accesible via https://destinyinternationalschools.sch.ng which would as a one stop information desimation tools</p>', 'no', '2022-11-18 07:16:07', '', '', '', 'https://destinyinternationalschools.sch.ng/uploads/gallery/media/1200px-GNOME_Web_logo--2018.svg.png', '0000-00-00', '0', 1);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (3, 'gallery', 'welcome', 'read/welcome', 'Welcome', NULL, NULL, NULL, NULL, '<p>Welcome<br />\r\n&nbsp;</p>', 'no', '2022-11-18 07:40:45', '', '', '', 'https://destinyinternationalschools.sch.ng/uploads/gallery/media/kids-graduation.png', '0000-00-00', '0', NULL);


#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'yellow', NULL, 1, 1, './uploads/school_content/logo/front_logo-6377706dd3a593.75781459.png', '', '', '[\"news\"]', 'https://facebook.com/destinyinternationalschoolsmakurdi', 'https://twitter.com/destinyinternationalschoolsmakurdi', '', '', '', '', '', '', 'Destiny International Schools, Makurdi', './uploads/school_content/logo/front_fav_icon-6377706dd4ff76.04752522.png', '2022-11-18 07:18:22');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_dureation` varchar(50) NOT NULL,
  `note` mediumtext NOT NULL,
  `call_type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: grades
#

DROP TABLE IF EXISTS `grades`;

CREATE TABLE `grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `category` int(11) DEFAULT NULL,
  `point` float(10,1) DEFAULT NULL,
  `mark_from` float(10,2) DEFAULT NULL,
  `mark_upto` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `grades` (`id`, `name`, `category`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'A', NULL, NULL, '75.00', '100.00', 'DISTINCTION', 'no', '2022-12-02 06:47:34', '0000-00-00 00:00:00');
INSERT INTO `grades` (`id`, `name`, `category`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'B', NULL, NULL, '65.00', '74.00', 'Very Good', 'no', '2022-12-02 06:53:55', '0000-00-00 00:00:00');
INSERT INTO `grades` (`id`, `name`, `category`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'C', NULL, NULL, '50.00', '64.00', 'Good', 'no', '2022-12-02 06:56:21', '0000-00-00 00:00:00');
INSERT INTO `grades` (`id`, `name`, `category`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'D', NULL, NULL, '40.00', '49.00', 'Fair', 'no', '2022-12-02 06:57:35', '0000-00-00 00:00:00');
INSERT INTO `grades` (`id`, `name`, `category`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'E', NULL, NULL, '0.00', '39.00', 'Fair', 'no', '2022-12-02 06:58:33', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: homework
#

DROP TABLE IF EXISTS `homework`;

CREATE TABLE `homework` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `homework_date` date NOT NULL,
  `submit_date` date NOT NULL,
  `staff_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `description` varchar(500) NOT NULL,
  `create_date` date NOT NULL,
  `document` varchar(200) NOT NULL,
  `created_by` int(11) NOT NULL,
  `evaluated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: homework_evaluation
#

DROP TABLE IF EXISTS `homework_evaluation`;

CREATE TABLE `homework_evaluation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `homework_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_name` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `intake` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: hostel_rooms
#

DROP TABLE IF EXISTS `hostel_rooms`;

CREATE TABLE `hostel_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_id` int(11) DEFAULT NULL,
  `room_type_id` int(11) DEFAULT NULL,
  `room_no` varchar(200) DEFAULT NULL,
  `no_of_bed` int(11) DEFAULT NULL,
  `cost_per_bed` float(10,2) DEFAULT 0.00,
  `title` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: id_card
#

DROP TABLE IF EXISTS `id_card`;

CREATE TABLE `id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `school_name` varchar(100) NOT NULL,
  `school_address` varchar(500) NOT NULL,
  `background` varchar(100) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `sign_image` varchar(100) NOT NULL,
  `header_color` varchar(100) NOT NULL,
  `enable_admission_no` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_class` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_fathers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_mothers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `status`) VALUES (1, 'Sample Student Identity Card', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` varchar(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `documents` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` varchar(100) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian (Creole)', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'no', 'no', '2017-04-06 01:08:33', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: libarary_members
#

DROP TABLE IF EXISTS `libarary_members`;

CREATE TABLE `libarary_members` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `library_card_no` varchar(50) DEFAULT NULL,
  `member_type` varchar(50) DEFAULT NULL,
  `member_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `is_class` int(10) NOT NULL DEFAULT 0,
  `group_list` text DEFAULT NULL,
  `user_list` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` varchar(10) DEFAULT '0',
  `is_sms` varchar(10) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `created_at`) VALUES (1, 'student_admission', '1', '0', '2018-05-22 09:00:07');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `created_at`) VALUES (2, 'exam_result', '1', '0', '2018-05-22 09:00:07');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `created_at`) VALUES (3, 'fee_submission', '1', '0', '2018-05-22 09:00:07');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `created_at`) VALUES (4, 'absent_attendence', '1', '0', '2018-07-11 13:43:02');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `created_at`) VALUES (5, 'login_credential', '1', '0', '2018-05-22 09:04:19');


#
# TABLE STRUCTURE FOR: online_result
#

DROP TABLE IF EXISTS `online_result`;

CREATE TABLE `online_result` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `admission_no` varchar(20) NOT NULL,
  `result_id` varchar(30) NOT NULL,
  `student_name` varchar(100) NOT NULL,
  `result_data` longtext NOT NULL,
  `session` varchar(40) NOT NULL,
  `class` varchar(40) NOT NULL,
  `arm` varchar(40) NOT NULL,
  `term` varchar(40) NOT NULL,
  `pin` varchar(100) NOT NULL,
  `disabled` varchar(100) NOT NULL DEFAULT '1',
  `last_update` varchar(40) NOT NULL,
  `created` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: payment_settings
#

DROP TABLE IF EXISTS `payment_settings`;

CREATE TABLE `payment_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'paypal', '', '', '', '', '', '', NULL, '', '', 'yes', '2018-07-12 01:26:13', '0000-00-00 00:00:00');
INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'stripe', NULL, '', '', '', NULL, NULL, NULL, '', '', 'no', '2018-07-12 01:26:26', '0000-00-00 00:00:00');
INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'payu', NULL, '', '', '', NULL, NULL, NULL, '', '', 'no', '2018-07-12 01:26:35', '0000-00-00 00:00:00');
INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'ccavenue', NULL, '', '', '', NULL, NULL, NULL, '', '', 'no', '2018-07-12 01:26:45', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: payslip_allowance
#

DROP TABLE IF EXISTS `payslip_allowance`;

CREATE TABLE `payslip_allowance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payslip_id` int(11) NOT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `cal_type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: permission_category
#

DROP TABLE IF EXISTS `permission_category`;

CREATE TABLE `permission_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `perm_group_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int(11) DEFAULT 0,
  `enable_add` int(11) DEFAULT 0,
  `enable_edit` int(11) DEFAULT 0,
  `enable_delete` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (1, 1, 'Student', 'student', 1, 1, 1, 1, '2018-06-22 11:47:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (2, 1, 'Import Student', 'import_student', 1, 0, 0, 0, '2018-06-22 11:47:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (3, 1, 'Student Categories', 'student_categories', 1, 1, 1, 1, '2018-06-22 11:47:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (4, 1, 'Student Houses', 'student_houses', 1, 1, 1, 1, '2018-06-22 11:47:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (5, 2, 'Collect Fees', 'collect_fees', 1, 1, 0, 1, '2018-06-22 11:51:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (6, 2, 'Fees Carry Forward', 'fees_carry_forward', 1, 0, 0, 0, '2018-06-27 01:48:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (7, 2, 'Fees Master', 'fees_master', 1, 1, 1, 1, '2018-06-27 01:48:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (8, 2, 'Fees Group', 'fees_group', 1, 1, 1, 1, '2018-06-22 11:51:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-22 11:53:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-22 11:52:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (11, 3, 'Search Income', 'search_income', 1, 0, 0, 0, '2018-06-22 11:53:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-22 11:54:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-22 11:53:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (14, 4, 'Search Expense', 'search_expense', 1, 0, 0, 0, '2018-06-22 11:54:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (15, 5, 'Student Attendance', 'student_attendance', 1, 1, 1, 0, '2018-06-22 11:54:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (16, 5, 'Student Attendance Report', 'student_attendance_report', 1, 0, 0, 0, '2018-06-22 11:54:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (17, 6, 'Exam', 'exam', 1, 1, 1, 1, '2018-06-22 11:56:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (19, 6, 'Marks Register', 'marks_register', 1, 1, 1, 0, '2018-06-22 11:56:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (20, 6, 'Marks Grade', 'marks_grade', 1, 1, 1, 1, '2018-06-22 11:55:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (21, 7, 'Class Timetable', 'class_timetable', 1, 1, 1, 0, '2018-06-22 12:01:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (22, 7, 'Assign Subject', 'assign_subject', 1, 1, 1, 1, '2018-06-22 12:01:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (23, 7, 'Subject', 'subject', 1, 1, 1, 1, '2018-06-22 12:02:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (24, 7, 'Class', 'class', 1, 1, 1, 1, '2018-06-22 12:02:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (25, 7, 'Section', 'section', 1, 1, 1, 1, '2018-06-22 12:01:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (26, 7, 'Promote Student', 'promote_student', 1, 0, 0, 0, '2018-06-22 12:02:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (27, 8, 'Upload Content', 'upload_content', 1, 1, 0, 1, '2018-06-22 12:03:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (28, 9, 'Books', 'books', 1, 1, 1, 1, '2018-06-22 12:04:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (29, 9, 'Issue Return Student', 'issue_return', 1, 0, 0, 0, '2018-06-22 12:03:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (30, 9, 'Add Staff Member', 'add_staff_member', 1, 0, 0, 0, '2018-07-02 13:07:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (31, 10, 'Issue Item', 'issue_item', 1, 0, 0, 0, '2018-06-22 12:04:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (32, 10, 'Item Stock', 'item_stock', 1, 1, 1, 1, '2018-06-22 12:05:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (33, 10, 'Item', 'item', 1, 1, 1, 1, '2018-06-22 12:05:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (34, 10, 'Store', 'store', 1, 1, 1, 1, '2018-06-22 12:06:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (35, 10, 'Supplier', 'supplier', 1, 1, 1, 1, '2018-06-22 12:06:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (37, 11, 'Routes', 'routes', 1, 1, 1, 1, '2018-06-22 12:09:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (38, 11, 'Vehicle', 'vehicle', 1, 1, 1, 1, '2018-06-22 12:09:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (39, 11, 'Assign Vehicle', 'assign_vehicle', 1, 1, 1, 1, '2018-06-27 06:09:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (40, 12, 'Hostel', 'hostel', 1, 1, 1, 1, '2018-06-22 12:10:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (41, 12, 'Room Type', 'room_type', 1, 1, 1, 1, '2018-06-22 12:10:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (42, 12, 'Hostel Rooms', 'hostel_rooms', 1, 1, 1, 1, '2018-06-25 07:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-22 12:11:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (44, 13, 'Email / SMS', 'email_sms', 1, 0, 0, 0, '2018-06-22 12:10:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (46, 13, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-06-22 12:11:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (47, 1, 'Student Report', 'student_report', 1, 0, 0, 0, '2018-07-03 12:19:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (48, 14, 'Transaction Report', 'transaction_report', 1, 0, 0, 0, '2018-07-06 13:13:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (49, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2018-07-06 13:13:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (53, 15, 'Languages', 'languages', 0, 1, 0, 0, '2018-06-22 12:13:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-05 10:38:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (55, 15, 'Session Setting', 'session_setting', 1, 1, 1, 1, '2018-06-22 12:14:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-05 10:38:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-05 10:38:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-05 10:38:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-05 10:38:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-05 10:38:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-09 05:20:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-09 05:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-22 12:16:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-22 12:16:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-22 12:17:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-22 12:17:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-03 10:09:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (68, 2, 'Fees Group Assign', 'fees_group_assign', 1, 0, 0, 0, '2018-06-22 11:50:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (69, 2, 'Fees Type', 'fees_type', 1, 1, 1, 1, '2018-06-22 11:49:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (70, 2, 'Fees Discount', 'fees_discount', 1, 1, 1, 1, '2018-06-22 11:50:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (71, 2, 'Fees Discount Assign', 'fees_discount_assign', 1, 0, 0, 0, '2018-06-22 11:50:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (72, 2, 'Fees Statement', 'fees_statement', 1, 0, 0, 0, '2018-06-22 11:48:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (73, 2, 'Search Fees Payment', 'search_fees_payment', 1, 0, 0, 0, '2018-06-22 11:50:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (74, 2, 'Search Due Fees', 'search_due_fees', 1, 0, 0, 0, '2018-06-22 11:50:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (75, 2, 'Balance Fees Report', 'balance_fees_report', 1, 0, 0, 0, '2018-06-22 11:48:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (76, 6, 'Exam Schedule', 'exam_schedule', 1, 1, 1, 0, '2018-06-22 11:55:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (77, 7, 'Assign Class Teacher', 'assign_class_teacher', 1, 1, 1, 1, '2018-06-22 12:00:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (78, 17, 'Admission Enquiry', 'admission_enquiry', 1, 1, 1, 1, '2018-06-22 12:21:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (79, 17, 'Follow Up Admission Enquiry', 'follow_up_admission_enquiry', 1, 1, 0, 1, '2018-06-22 12:21:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-22 12:18:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-22 12:20:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-22 12:20:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-22 12:20:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (84, 17, 'Complain', 'complaint', 1, 1, 1, 1, '2018-07-03 10:10:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (85, 17, 'Setup Font Office', 'setup_font_office', 1, 1, 1, 1, '2018-06-22 12:19:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-22 12:23:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-22 12:23:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-22 12:23:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (89, 18, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2018-06-22 12:22:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 0, 1, '2018-06-22 12:22:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (91, 18, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2018-06-22 12:22:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (93, 19, 'Homework', 'homework', 1, 1, 1, 1, '2018-06-22 12:23:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (94, 19, 'Homework Evaluation', 'homework_evaluation', 1, 1, 0, 0, '2018-06-27 04:37:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (95, 19, 'Homework Report', 'homework_report', 1, 0, 0, 0, '2018-06-22 12:23:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (96, 20, 'Student Certificate', 'student_certificate', 1, 1, 1, 1, '2018-07-06 12:11:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (97, 20, 'Generate Certificate', 'generate_certificate', 1, 0, 0, 0, '2018-07-06 12:07:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (98, 20, 'Student ID Card', 'student_id_card', 1, 1, 1, 1, '2018-07-06 12:11:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (99, 20, 'Generate ID Card', 'generate_id_card', 1, 0, 0, 0, '2018-07-06 12:11:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-22 12:24:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-22 12:04:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (105, 1, 'Student Parent Login Details', 'student_parent_login_details', 1, 0, 0, 0, '2018-06-22 11:48:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (106, 22, 'Quick Session Change', 'quick_session_change', 1, 0, 0, 0, '2018-06-22 12:24:45');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (107, 1, 'Disable Student', 'disable_student', 1, 0, 0, 0, '2018-06-25 07:51:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 1, 1, 1, '2018-07-02 11:47:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (109, 18, 'Apply Leave', 'apply_leave', 1, 1, 1, 1, '2018-06-26 05:23:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (110, 18, 'Leave Types ', 'leave_types', 1, 1, 1, 1, '2018-07-02 11:47:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-26 05:27:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-26 05:27:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (113, 22, 'Fees Collection And Expense Monthly Chart', 'fees_collection_and_expense_monthly_chart', 1, 0, 0, 0, '2018-07-03 08:38:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (114, 22, 'Fees Collection And Expense Yearly Chart', 'fees_collection_and_expense_yearly_chart', 1, 0, 0, 0, '2018-07-03 08:38:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (115, 22, 'Monthly Fees Collection Widget', 'Monthly fees_collection_widget', 1, 0, 0, 0, '2018-07-03 08:43:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (116, 22, 'Monthly Expense Widget', 'monthly_expense_widget', 1, 0, 0, 0, '2018-07-03 08:43:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (117, 22, 'Student Count Widget', 'student_count_widget', 1, 0, 0, 0, '2018-07-03 08:43:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-03 08:43:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (119, 1, 'Guardian Report', 'guardian_report', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (120, 1, 'Student History', 'student_history', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (121, 1, 'Student Login Credential', 'student_login_credential', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (122, 5, 'Attendance By Date', 'attendance_by_date', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (123, 9, 'Add Student', 'add_student', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (124, 11, 'Student Transport Report', 'student_transport_report', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (125, 12, 'Student Hostel Report', 'student_hostel_report', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (126, 15, 'User Status', 'user_status', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-03 10:12:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (128, 1, 'Student Timeline', 'student_timeline', 0, 1, 0, 1, '2018-07-05 09:38:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (129, 18, 'Staff Timeline', 'staff_timeline', 0, 1, 0, 1, '2018-07-05 09:38:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-09 05:47:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-09 05:47:17');


#
# TABLE STRUCTURE FOR: permission_group
#

DROP TABLE IF EXISTS `permission_group`;

CREATE TABLE `permission_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT 0,
  `system` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (1, 'Student Information', 'student_information', 1, 1, '2018-06-27 05:09:31');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (2, 'Fees Collection', 'fees_collection', 1, 0, '2019-03-09 13:18:57');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (3, 'Income', 'income', 1, 0, '2018-06-27 02:19:05');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (4, 'Expense', 'expense', 1, 0, '2018-07-04 03:07:33');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (5, 'Student Attendance', 'student_attendance', 1, 0, '2018-07-02 09:18:08');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (6, 'Examination', 'examination', 1, 0, '2018-07-11 04:19:08');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (7, 'Academics', 'academics', 1, 1, '2018-07-02 08:55:43');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (8, 'Download Center', 'download_center', 1, 0, '2018-07-02 09:19:29');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (9, 'Library', 'library', 1, 0, '2019-03-09 13:17:09');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (10, 'Inventory', 'inventory', 1, 0, '2018-06-27 02:18:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (11, 'Transport', 'transport', 1, 0, '2018-06-27 09:21:26');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (12, 'Hostel', 'hostel', 1, 0, '2018-07-02 09:19:32');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (13, 'Communicate', 'communicate', 1, 0, '2018-07-02 09:20:00');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (14, 'Reports', 'reports', 1, 1, '2018-06-27 05:10:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (15, 'System Settings', 'system_settings', 1, 1, '2018-06-27 05:10:28');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (16, 'Front CMS', 'front_cms', 1, 0, '2018-07-10 06:46:54');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (17, 'Front Office', 'front_office', 1, 0, '2019-03-09 13:16:33');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (18, 'Human Resource', 'human_resource', 1, 1, '2018-06-27 05:11:02');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (19, 'Homework', 'homework', 1, 0, '2018-06-27 02:19:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (20, 'Certificate', 'certificate', 1, 0, '2018-06-27 09:21:29');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '2018-06-27 05:12:25');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '2018-06-27 05:11:17');


#
# TABLE STRUCTURE FOR: pins
#

DROP TABLE IF EXISTS `pins`;

CREATE TABLE `pins` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `pin` varchar(40) NOT NULL,
  `admission_no` varchar(20) NOT NULL,
  `result_id` varchar(20) NOT NULL,
  `usage` int(1) NOT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_used` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `pin` (`pin`)
) ENGINE=InnoDB AUTO_INCREMENT=404 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: read_notification
#

DROP TABLE IF EXISTS `read_notification`;

CREATE TABLE `read_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `parent_id` int(10) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `notification_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: reference
#

DROP TABLE IF EXISTS `reference`;

CREATE TABLE `reference` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `slug` varchar(150) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `is_superadmin` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`, `updated_at`) VALUES (1, 'Admin', NULL, 0, 1, 0, '2018-06-30 11:39:11', '0000-00-00 00:00:00');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`, `updated_at`) VALUES (2, 'Teacher', NULL, 0, 1, 0, '2018-06-30 11:39:14', '0000-00-00 00:00:00');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`, `updated_at`) VALUES (3, 'Accountant', NULL, 0, 1, 0, '2018-06-30 11:39:17', '0000-00-00 00:00:00');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`, `updated_at`) VALUES (4, 'Librarian', NULL, 0, 1, 0, '2018-06-30 11:39:21', '0000-00-00 00:00:00');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`, `updated_at`) VALUES (6, 'Receptionist', NULL, 0, 1, 0, '2018-07-02 01:39:03', '0000-00-00 00:00:00');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`, `updated_at`) VALUES (7, 'Super Admin', NULL, 0, 1, 1, '2018-07-11 10:11:29', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: roles_permissions
#

DROP TABLE IF EXISTS `roles_permissions`;

CREATE TABLE `roles_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `perm_cat_id` int(11) DEFAULT NULL,
  `can_view` int(11) DEFAULT NULL,
  `can_add` int(11) DEFAULT NULL,
  `can_edit` int(11) DEFAULT NULL,
  `can_delete` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=637 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (3, 1, 3, 1, 1, 1, 1, '2018-07-06 11:12:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (4, 1, 4, 1, 1, 1, 1, '2018-07-06 11:13:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (6, 1, 5, 1, 1, 0, 1, '2018-07-02 12:49:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (8, 1, 7, 1, 1, 1, 1, '2018-07-06 11:13:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (9, 1, 8, 1, 1, 1, 1, '2018-07-06 11:13:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (10, 1, 17, 1, 1, 1, 1, '2018-07-06 11:18:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (11, 1, 78, 1, 1, 1, 1, '2018-07-03 02:19:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (13, 1, 69, 1, 1, 1, 1, '2018-07-06 11:14:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (14, 1, 70, 1, 1, 1, 1, '2018-07-06 11:14:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (23, 1, 12, 1, 1, 1, 1, '2018-07-06 11:15:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (24, 1, 13, 1, 1, 1, 1, '2018-07-06 11:18:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (26, 1, 15, 1, 1, 1, 0, '2018-07-02 12:54:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (28, 1, 19, 1, 1, 1, 0, '2018-07-02 13:01:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (29, 1, 20, 1, 1, 1, 1, '2018-07-06 11:19:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (30, 1, 76, 1, 1, 1, 0, '2018-07-02 13:01:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (31, 1, 21, 1, 1, 1, 0, '2018-07-02 13:01:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (32, 1, 22, 1, 1, 1, 1, '2018-07-02 13:02:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (33, 1, 23, 1, 1, 1, 1, '2018-07-06 11:20:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (34, 1, 24, 1, 1, 1, 1, '2018-07-06 11:20:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (35, 1, 25, 1, 1, 1, 1, '2018-07-06 11:22:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (37, 1, 77, 1, 1, 1, 1, '2018-07-06 11:19:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (43, 1, 32, 1, 1, 1, 1, '2018-07-06 11:52:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (44, 1, 33, 1, 1, 1, 1, '2018-07-06 11:52:29');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (45, 1, 34, 1, 1, 1, 1, '2018-07-06 11:53:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (46, 1, 35, 1, 1, 1, 1, '2018-07-06 11:54:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (47, 1, 104, 1, 1, 1, 1, '2018-07-06 11:53:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (48, 1, 37, 1, 1, 1, 1, '2018-07-06 11:55:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (49, 1, 38, 1, 1, 1, 1, '2018-07-09 06:45:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (53, 1, 43, 1, 1, 1, 1, '2018-07-10 11:00:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (58, 1, 52, 1, 1, 0, 1, '2018-07-09 04:49:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (61, 1, 55, 1, 1, 1, 1, '2018-07-02 10:54:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (67, 1, 61, 1, 1, 0, 1, '2018-07-09 07:29:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (68, 1, 62, 1, 1, 0, 1, '2018-07-09 07:29:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (69, 1, 63, 1, 1, 0, 1, '2018-07-09 05:21:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (70, 1, 64, 1, 1, 1, 1, '2018-07-09 04:32:19');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (71, 1, 65, 1, 1, 1, 1, '2018-07-09 04:41:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (72, 1, 66, 1, 1, 1, 1, '2018-07-09 04:43:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (73, 1, 67, 1, 1, 1, 1, '2018-07-09 04:44:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (74, 1, 79, 1, 1, 0, 1, '2018-07-02 13:34:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (75, 1, 80, 1, 1, 1, 1, '2018-07-06 11:11:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (76, 1, 81, 1, 1, 1, 1, '2018-07-06 11:11:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (78, 1, 83, 1, 1, 1, 1, '2018-07-06 11:11:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (79, 1, 84, 1, 1, 1, 1, '2018-07-06 11:11:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (80, 1, 85, 1, 1, 1, 1, '2018-07-12 01:46:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (83, 1, 88, 1, 1, 1, 0, '2018-07-03 13:34:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (87, 1, 92, 1, 1, 1, 1, '2018-06-26 05:03:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (88, 1, 93, 1, 1, 1, 1, '2018-07-09 02:54:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (94, 1, 82, 1, 1, 1, 1, '2018-07-06 11:11:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (120, 1, 39, 1, 1, 1, 1, '2018-07-06 11:56:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (140, 1, 110, 1, 1, 1, 1, '2018-07-06 11:25:08');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (141, 1, 111, 1, 1, 1, 1, '2018-07-06 11:26:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (142, 1, 112, 1, 1, 1, 1, '2018-07-06 11:26:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (145, 1, 94, 1, 1, 0, 0, '2018-07-09 02:50:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (147, 2, 43, 1, 1, 1, 1, '2018-06-30 09:16:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (148, 2, 44, 1, 0, 0, 0, '2018-06-27 12:47:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (149, 2, 46, 1, 0, 0, 0, '2018-06-28 01:56:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (156, 1, 9, 1, 1, 1, 1, '2018-07-06 11:14:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (157, 1, 10, 1, 1, 1, 1, '2018-07-06 11:15:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (159, 1, 40, 1, 1, 1, 1, '2018-07-09 06:39:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (160, 1, 41, 1, 1, 1, 1, '2018-07-06 11:57:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (161, 1, 42, 1, 1, 1, 1, '2018-07-09 06:43:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (169, 1, 27, 1, 1, 0, 1, '2018-07-02 13:06:58');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (178, 1, 54, 1, 0, 1, 0, '2018-07-05 10:39:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (179, 1, 56, 1, 0, 1, 0, '2018-07-05 10:39:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (180, 1, 57, 1, 0, 1, 0, '2018-07-05 10:39:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (181, 1, 58, 1, 0, 1, 0, '2018-07-05 10:39:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (182, 1, 59, 1, 0, 1, 0, '2018-07-05 10:39:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (183, 1, 60, 1, 0, 1, 0, '2018-07-05 10:39:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (190, 1, 105, 1, 0, 0, 0, '2018-07-02 12:43:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (193, 1, 6, 1, 0, 0, 0, '2018-07-02 12:49:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (194, 1, 68, 1, 0, 0, 0, '2018-07-02 12:49:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (196, 1, 72, 1, 0, 0, 0, '2018-07-02 12:49:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (197, 1, 73, 1, 0, 0, 0, '2018-07-02 12:49:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (198, 1, 74, 1, 0, 0, 0, '2018-07-02 12:49:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (199, 1, 75, 1, 0, 0, 0, '2018-07-02 12:49:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (201, 1, 14, 1, 0, 0, 0, '2018-07-02 12:52:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (203, 1, 16, 1, 0, 0, 0, '2018-07-02 12:54:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (204, 1, 26, 1, 0, 0, 0, '2018-07-02 13:02:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (206, 1, 29, 1, 0, 0, 0, '2018-07-02 13:13:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (207, 1, 30, 1, 0, 0, 0, '2018-07-02 13:13:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (208, 1, 31, 1, 0, 0, 0, '2018-07-02 13:15:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (215, 1, 50, 1, 0, 0, 0, '2018-07-02 13:34:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (216, 1, 51, 1, 0, 0, 0, '2018-07-02 13:34:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (222, 1, 1, 1, 1, 1, 1, '2018-07-10 11:00:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (225, 1, 108, 1, 1, 1, 1, '2018-07-09 03:47:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (227, 1, 91, 1, 0, 0, 0, '2018-07-03 03:19:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (229, 1, 89, 1, 0, 0, 0, '2018-07-03 03:30:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (230, 10, 53, 0, 1, 0, 0, '2018-07-03 05:22:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (231, 10, 54, 0, 0, 1, 0, '2018-07-03 05:22:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (232, 10, 55, 1, 1, 1, 1, '2018-07-03 05:28:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (233, 10, 56, 0, 0, 1, 0, '2018-07-03 05:22:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (235, 10, 58, 0, 0, 1, 0, '2018-07-03 05:22:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (236, 10, 59, 0, 0, 1, 0, '2018-07-03 05:22:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (239, 10, 1, 1, 1, 1, 1, '2018-07-03 05:46:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (241, 10, 3, 1, 0, 0, 0, '2018-07-03 05:53:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (242, 10, 2, 1, 0, 0, 0, '2018-07-03 05:54:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (243, 10, 4, 1, 0, 1, 1, '2018-07-03 06:01:24');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (245, 10, 107, 1, 0, 0, 0, '2018-07-03 06:06:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (246, 10, 5, 1, 1, 0, 1, '2018-07-03 06:08:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (247, 10, 7, 1, 1, 1, 1, '2018-07-03 06:12:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (248, 10, 68, 1, 0, 0, 0, '2018-07-03 06:12:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (249, 10, 69, 1, 1, 1, 1, '2018-07-03 06:19:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (250, 10, 70, 1, 0, 0, 1, '2018-07-03 06:22:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (251, 10, 72, 1, 0, 0, 0, '2018-07-03 06:26:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (252, 10, 73, 1, 0, 0, 0, '2018-07-03 06:26:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (253, 10, 74, 1, 0, 0, 0, '2018-07-03 06:28:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (254, 10, 75, 1, 0, 0, 0, '2018-07-03 06:28:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (255, 10, 9, 1, 1, 1, 1, '2018-07-03 06:32:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (256, 10, 10, 1, 1, 1, 1, '2018-07-03 06:33:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (257, 10, 11, 1, 0, 0, 0, '2018-07-03 06:33:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (258, 10, 12, 1, 1, 1, 1, '2018-07-03 06:38:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (259, 10, 13, 1, 1, 1, 1, '2018-07-03 06:38:40');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (260, 10, 14, 1, 0, 0, 0, '2018-07-03 06:38:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (261, 10, 15, 1, 1, 1, 0, '2018-07-03 06:41:28');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (262, 10, 16, 1, 0, 0, 0, '2018-07-03 06:42:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (263, 10, 17, 1, 1, 1, 1, '2018-07-03 06:44:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (264, 10, 19, 1, 1, 1, 0, '2018-07-03 06:45:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (265, 10, 20, 1, 1, 1, 1, '2018-07-03 06:48:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (266, 10, 76, 1, 0, 0, 0, '2018-07-03 06:51:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (267, 10, 21, 1, 1, 1, 0, '2018-07-03 06:52:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (268, 10, 22, 1, 1, 1, 1, '2018-07-03 06:55:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (269, 10, 23, 1, 1, 1, 1, '2018-07-03 06:57:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (270, 10, 24, 1, 1, 1, 1, '2018-07-03 06:57:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (271, 10, 25, 1, 1, 1, 1, '2018-07-03 06:57:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (272, 10, 26, 1, 0, 0, 0, '2018-07-03 06:58:25');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (273, 10, 77, 1, 1, 1, 1, '2018-07-03 06:59:57');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (274, 10, 27, 1, 1, 0, 1, '2018-07-03 07:00:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (275, 10, 28, 1, 1, 1, 1, '2018-07-03 07:03:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (276, 10, 29, 1, 0, 0, 0, '2018-07-03 07:04:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (277, 10, 30, 1, 0, 0, 0, '2018-07-03 07:04:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (278, 10, 31, 1, 0, 0, 0, '2018-07-03 07:04:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (279, 10, 32, 1, 1, 1, 1, '2018-07-03 07:05:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (280, 10, 33, 1, 1, 1, 1, '2018-07-03 07:06:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (281, 10, 34, 1, 1, 1, 1, '2018-07-03 07:08:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (282, 10, 35, 1, 1, 1, 1, '2018-07-03 07:08:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (283, 10, 104, 1, 1, 1, 1, '2018-07-03 07:10:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (284, 10, 37, 1, 1, 1, 1, '2018-07-03 07:12:42');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (285, 10, 38, 1, 1, 1, 1, '2018-07-03 07:13:56');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (286, 10, 39, 1, 1, 1, 1, '2018-07-03 07:15:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (287, 10, 40, 1, 1, 1, 1, '2018-07-03 07:17:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (288, 10, 41, 1, 1, 1, 1, '2018-07-03 07:18:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (289, 10, 42, 1, 1, 1, 1, '2018-07-03 07:19:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (290, 10, 43, 1, 1, 1, 1, '2018-07-03 07:21:15');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (291, 10, 44, 1, 0, 0, 0, '2018-07-03 07:22:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (292, 10, 46, 1, 0, 0, 0, '2018-07-03 07:22:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (293, 10, 50, 1, 0, 0, 0, '2018-07-03 07:22:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (294, 10, 51, 1, 0, 0, 0, '2018-07-03 07:22:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (295, 10, 60, 0, 0, 1, 0, '2018-07-03 07:25:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (296, 10, 61, 1, 1, 1, 1, '2018-07-03 07:26:52');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (297, 10, 62, 1, 1, 1, 1, '2018-07-03 07:28:53');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (298, 10, 63, 1, 1, 0, 0, '2018-07-03 07:29:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (299, 10, 64, 1, 1, 1, 1, '2018-07-03 07:30:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (300, 10, 65, 1, 1, 1, 1, '2018-07-03 07:32:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (301, 10, 66, 1, 1, 1, 1, '2018-07-03 07:32:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (302, 10, 67, 1, 0, 0, 0, '2018-07-03 07:32:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (303, 10, 78, 1, 1, 1, 1, '2018-07-04 05:40:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (307, 1, 126, 1, 0, 0, 0, '2018-07-03 10:56:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (310, 1, 119, 1, 0, 0, 0, '2018-07-03 11:45:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (311, 1, 120, 1, 0, 0, 0, '2018-07-03 11:45:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (312, 1, 107, 1, 0, 0, 0, '2018-07-03 11:45:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (313, 1, 122, 1, 0, 0, 0, '2018-07-03 11:49:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (315, 1, 123, 1, 0, 0, 0, '2018-07-03 11:57:03');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (317, 1, 124, 1, 0, 0, 0, '2018-07-03 11:59:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (320, 1, 47, 1, 0, 0, 0, '2018-07-03 12:31:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (321, 1, 121, 1, 0, 0, 0, '2018-07-03 12:31:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (322, 1, 109, 1, 1, 1, 1, '2018-07-03 12:40:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (369, 1, 102, 1, 1, 1, 1, '2018-07-11 13:31:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (372, 10, 79, 1, 1, 0, 0, '2018-07-04 05:40:04');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (373, 10, 80, 1, 1, 1, 1, '2018-07-04 05:53:09');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (374, 10, 81, 1, 1, 1, 1, '2018-07-04 05:53:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (375, 10, 82, 1, 1, 1, 1, '2018-07-04 05:56:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (376, 10, 83, 1, 1, 1, 1, '2018-07-04 05:57:55');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (377, 10, 84, 1, 1, 1, 1, '2018-07-04 06:00:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (378, 10, 85, 1, 1, 1, 1, '2018-07-04 06:02:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (379, 10, 86, 1, 1, 1, 1, '2018-07-04 06:16:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (380, 10, 87, 1, 0, 0, 0, '2018-07-04 06:19:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (381, 10, 88, 1, 1, 1, 0, '2018-07-04 06:21:20');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (382, 10, 89, 1, 0, 0, 0, '2018-07-04 06:21:51');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (383, 10, 90, 1, 1, 0, 1, '2018-07-04 06:25:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (384, 10, 91, 1, 0, 0, 0, '2018-07-04 06:25:01');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (385, 10, 108, 1, 1, 1, 1, '2018-07-04 06:27:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (386, 10, 109, 1, 1, 1, 1, '2018-07-04 06:28:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (387, 10, 110, 1, 1, 1, 1, '2018-07-04 06:32:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (388, 10, 111, 1, 1, 1, 1, '2018-07-04 06:33:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (389, 10, 112, 1, 1, 1, 1, '2018-07-04 06:35:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (390, 10, 127, 1, 0, 0, 0, '2018-07-04 06:35:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (391, 10, 93, 1, 1, 1, 1, '2018-07-04 06:37:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (392, 10, 94, 1, 1, 0, 0, '2018-07-04 06:38:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (394, 10, 95, 1, 0, 0, 0, '2018-07-04 06:38:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (395, 10, 102, 1, 1, 1, 1, '2018-07-04 06:41:02');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (396, 10, 106, 1, 0, 0, 0, '2018-07-04 06:41:39');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (397, 10, 113, 1, 0, 0, 0, '2018-07-04 06:42:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (398, 10, 114, 1, 0, 0, 0, '2018-07-04 06:42:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (399, 10, 115, 1, 0, 0, 0, '2018-07-04 06:48:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (400, 10, 116, 1, 0, 0, 0, '2018-07-04 06:48:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (401, 10, 117, 1, 0, 0, 0, '2018-07-04 06:49:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (402, 10, 118, 1, 0, 0, 0, '2018-07-04 06:49:43');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (411, 1, 2, 1, 0, 0, 0, '2018-07-04 09:46:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (412, 1, 11, 1, 0, 0, 0, '2018-07-04 10:24:05');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (416, 2, 3, 1, 0, 0, 0, '2019-03-15 18:29:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (428, 2, 4, 1, 0, 0, 0, '2019-03-15 18:29:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (432, 1, 128, 0, 1, 0, 1, '2018-07-05 09:39:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (434, 1, 125, 1, 0, 0, 0, '2018-07-06 11:29:26');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (435, 1, 96, 1, 1, 1, 1, '2018-07-09 02:33:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (437, 1, 98, 1, 1, 1, 1, '2018-07-09 02:44:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (444, 1, 99, 1, 0, 0, 0, '2018-07-06 13:11:22');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (445, 1, 48, 1, 0, 0, 0, '2018-07-06 13:19:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (446, 1, 49, 1, 0, 0, 0, '2018-07-06 13:19:35');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (448, 1, 71, 1, 0, 0, 0, '2018-07-08 05:17:06');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (453, 1, 106, 1, 0, 0, 0, '2018-07-09 02:17:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (454, 1, 113, 1, 0, 0, 0, '2018-07-09 02:17:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (455, 1, 114, 1, 0, 0, 0, '2018-07-09 02:17:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (456, 1, 115, 1, 0, 0, 0, '2018-07-09 02:17:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (457, 1, 116, 1, 0, 0, 0, '2018-07-09 02:17:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (458, 1, 117, 1, 0, 0, 0, '2018-07-09 02:17:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (459, 1, 118, 1, 0, 0, 0, '2018-07-09 02:17:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (461, 1, 97, 1, 0, 0, 0, '2018-07-09 02:30:16');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (462, 1, 95, 1, 0, 0, 0, '2018-07-09 02:48:41');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (464, 1, 86, 1, 1, 1, 1, '2018-07-09 07:39:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (466, 1, 129, 0, 1, 0, 1, '2018-07-09 03:09:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (467, 1, 87, 1, 0, 0, 0, '2018-07-09 03:11:59');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (468, 1, 90, 1, 1, 0, 1, '2018-07-09 03:22:50');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (471, 1, 53, 0, 1, 0, 0, '2018-07-09 04:50:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (474, 1, 130, 1, 1, 0, 1, '2018-07-09 12:26:36');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (476, 1, 131, 1, 0, 0, 0, '2018-07-09 06:23:32');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (477, 2, 1, 1, 0, 0, 0, '2019-03-15 18:29:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (478, 2, 2, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (479, 2, 47, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (480, 2, 105, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (482, 2, 119, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (483, 2, 120, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (485, 2, 15, 1, 1, 1, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (486, 2, 16, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (487, 2, 122, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (492, 2, 21, 1, 0, 0, 0, '2018-07-12 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (493, 2, 22, 1, 0, 0, 0, '2018-07-12 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (494, 2, 23, 1, 0, 0, 0, '2018-07-12 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (495, 2, 24, 1, 0, 0, 0, '2018-07-12 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (496, 2, 25, 1, 0, 0, 0, '2018-07-12 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (498, 2, 77, 1, 0, 0, 0, '2018-07-12 01:50:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (499, 2, 27, 1, 1, 0, 1, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (502, 2, 93, 1, 1, 1, 1, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (503, 2, 94, 1, 1, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (504, 2, 95, 1, 0, 0, 0, '2018-07-10 08:17:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (505, 3, 5, 1, 1, 0, 1, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (506, 3, 6, 1, 0, 0, 0, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (507, 3, 7, 1, 1, 1, 1, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (508, 3, 8, 1, 1, 1, 1, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (509, 3, 68, 1, 0, 0, 0, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (510, 3, 69, 1, 1, 1, 1, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (511, 3, 70, 1, 1, 1, 1, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (512, 3, 71, 1, 0, 0, 0, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (513, 3, 72, 1, 0, 0, 0, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (514, 3, 73, 1, 0, 0, 0, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (515, 3, 74, 1, 0, 0, 0, '2018-07-10 08:37:30');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (517, 3, 75, 1, 0, 0, 0, '2018-07-10 08:40:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (518, 3, 9, 1, 1, 1, 1, '2018-07-10 08:40:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (519, 3, 10, 1, 1, 1, 1, '2018-07-10 08:40:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (520, 3, 11, 1, 0, 0, 0, '2018-07-10 08:40:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (521, 3, 12, 1, 1, 1, 1, '2018-07-10 08:47:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (522, 3, 13, 1, 1, 1, 1, '2018-07-10 08:47:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (523, 3, 14, 1, 0, 0, 0, '2018-07-10 08:47:00');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (524, 3, 86, 1, 1, 1, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (525, 3, 87, 1, 0, 0, 0, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (526, 3, 88, 1, 1, 1, 0, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (527, 3, 89, 1, 0, 0, 0, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (528, 3, 90, 1, 1, 0, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (529, 3, 91, 1, 0, 0, 0, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (530, 3, 108, 1, 1, 1, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (531, 3, 109, 1, 1, 1, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (532, 3, 110, 1, 1, 1, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (533, 3, 111, 1, 1, 1, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (534, 3, 112, 1, 1, 1, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (535, 3, 127, 1, 0, 0, 0, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (536, 3, 129, 0, 1, 0, 1, '2018-07-10 08:48:44');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (537, 3, 43, 1, 1, 1, 1, '2018-07-10 08:49:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (538, 3, 44, 1, 0, 0, 0, '2018-07-10 08:49:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (539, 3, 46, 1, 0, 0, 0, '2018-07-10 08:49:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (540, 3, 31, 1, 0, 0, 0, '2018-07-10 08:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (541, 3, 32, 1, 1, 1, 1, '2018-07-10 08:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (542, 3, 33, 1, 1, 1, 1, '2018-07-10 08:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (543, 3, 34, 1, 1, 1, 1, '2018-07-10 08:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (544, 3, 35, 1, 1, 1, 1, '2018-07-10 08:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (545, 3, 104, 1, 1, 1, 1, '2018-07-10 08:50:38');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (546, 3, 37, 1, 1, 1, 1, '2018-07-10 08:52:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (547, 3, 38, 1, 1, 1, 1, '2018-07-10 08:52:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (548, 3, 39, 1, 1, 1, 1, '2018-07-10 08:52:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (549, 3, 124, 1, 0, 0, 0, '2018-07-10 08:52:17');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (553, 6, 78, 1, 1, 1, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (554, 6, 79, 1, 1, 0, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (555, 6, 80, 1, 1, 1, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (556, 6, 81, 1, 1, 1, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (557, 6, 82, 1, 1, 1, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (558, 6, 83, 1, 1, 1, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (559, 6, 84, 1, 1, 1, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (560, 6, 85, 1, 1, 1, 1, '2018-07-10 09:02:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (561, 6, 86, 1, 0, 0, 0, '2018-07-10 09:11:10');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (574, 6, 43, 1, 1, 1, 1, '2018-07-10 09:05:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (575, 6, 44, 1, 0, 0, 0, '2018-07-10 09:05:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (576, 6, 46, 1, 0, 0, 0, '2018-07-10 09:05:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (578, 6, 102, 1, 1, 1, 1, '2018-07-10 09:20:33');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (579, 4, 28, 1, 1, 1, 1, '2018-07-10 09:23:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (580, 4, 29, 1, 0, 0, 0, '2018-07-10 09:23:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (581, 4, 30, 1, 0, 0, 0, '2018-07-10 09:23:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (582, 4, 123, 1, 0, 0, 0, '2018-07-10 09:23:54');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (583, 4, 86, 1, 0, 0, 0, '2018-07-10 09:24:13');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (584, 4, 43, 1, 1, 1, 1, '2018-07-10 09:25:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (585, 4, 44, 1, 0, 0, 0, '2018-07-10 09:25:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (586, 4, 46, 1, 0, 0, 0, '2018-07-10 09:25:14');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (588, 2, 102, 1, 1, 1, 1, '2018-07-12 01:47:45');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (589, 2, 106, 1, 0, 0, 0, '2018-07-10 09:25:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (590, 2, 117, 1, 0, 0, 0, '2018-07-10 09:25:37');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (591, 3, 40, 1, 1, 1, 1, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (592, 3, 41, 1, 1, 1, 1, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (593, 3, 42, 1, 1, 1, 1, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (594, 3, 125, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (595, 3, 48, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (596, 3, 49, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (597, 3, 102, 1, 1, 1, 1, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (598, 3, 106, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (599, 3, 113, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (600, 3, 114, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (601, 3, 115, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (602, 3, 116, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (603, 3, 117, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (604, 3, 118, 1, 0, 0, 0, '2018-07-10 09:28:12');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (609, 6, 117, 1, 0, 0, 0, '2018-07-10 09:30:48');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (611, 2, 86, 1, 0, 0, 0, '2018-07-10 09:38:49');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (612, 1, 44, 1, 0, 0, 0, '2018-07-10 11:00:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (613, 1, 46, 1, 0, 0, 0, '2018-07-10 11:00:31');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (616, 1, 127, 1, 0, 0, 0, '2018-07-11 04:22:46');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (617, 2, 17, 1, 0, 0, 0, '2019-03-15 18:29:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (618, 2, 19, 1, 0, 0, 0, '2019-03-15 18:29:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (619, 2, 20, 1, 0, 0, 0, '2019-03-15 18:29:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (620, 2, 76, 1, 0, 0, 0, '2019-03-15 18:29:07');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (621, 2, 107, 1, 0, 0, 0, '2018-07-11 08:26:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (622, 2, 121, 1, 0, 0, 0, '2018-07-11 08:26:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (623, 2, 128, 0, 1, 0, 1, '2018-07-11 08:26:27');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (625, 1, 28, 1, 1, 1, 1, '2018-07-11 10:57:18');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (626, 6, 1, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (627, 6, 21, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (628, 6, 22, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (629, 6, 23, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (630, 6, 24, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (631, 6, 25, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (632, 6, 77, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (633, 6, 106, 1, 0, 0, 0, '2018-07-12 01:53:47');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (634, 4, 102, 1, 1, 1, 1, '2018-07-12 01:54:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (635, 4, 106, 1, 0, 0, 0, '2018-07-12 01:54:23');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (636, 4, 117, 1, 0, 0, 0, '2018-07-12 01:54:23');


#
# TABLE STRUCTURE FOR: room_types
#

DROP TABLE IF EXISTS `room_types`;

CREATE TABLE `room_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `room_type` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: sch_settings
#

DROP TABLE IF EXISTS `sch_settings`;

CREATE TABLE `sch_settings` (
  `id` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `lang_id` int(11) DEFAULT NULL,
  `dise_code` varchar(50) DEFAULT NULL,
  `date_format` varchar(50) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `is_rtl` varchar(10) DEFAULT 'disabled',
  `timezone` varchar(30) DEFAULT 'UTC',
  `session_id` int(11) DEFAULT NULL,
  `start_month` varchar(40) NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  `theme` varchar(200) NOT NULL DEFAULT 'default.jpg',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cron_secret_key` varchar(100) NOT NULL,
  `fee_due_days` int(3) DEFAULT 0,
  `class_teacher` varchar(100) NOT NULL,
  KEY `lang_id` (`lang_id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `sch_settings` (`id`, `name`, `email`, `phone`, `address`, `lang_id`, `dise_code`, `date_format`, `currency`, `currency_symbol`, `is_rtl`, `timezone`, `session_id`, `start_month`, `image`, `theme`, `is_active`, `created_at`, `updated_at`, `cron_secret_key`, `fee_due_days`, `class_teacher`) VALUES (1, 'DESTINY INTERNATIONAL SCHOOLS', 'info@destinyinternationalschools.sch.ng', '07035108999', 'Behind St. Mary Primary School, North-Bank, Makurdi', 4, '', 'd/m/Y', 'NGN', '₦', 'disabled', 'Africa/Lagos', 16, '9', '1.png', 'default.jpg', 'no', '2022-11-18 07:05:55', '0000-00-00 00:00:00', '', 90, 'no');


#
# TABLE STRUCTURE FOR: school_houses
#

DROP TABLE IF EXISTS `school_houses`;

CREATE TABLE `school_houses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `house_name` varchar(200) NOT NULL,
  `description` varchar(400) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: sections
#

DROP TABLE IF EXISTS `sections`;

CREATE TABLE `sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `sections` (`id`, `section`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'A', 'no', '2022-11-24 04:57:35', '0000-00-00 00:00:00');
INSERT INTO `sections` (`id`, `section`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Jss 1', 'no', '2022-12-02 06:31:56', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: send_notification
#

DROP TABLE IF EXISTS `send_notification`;

CREATE TABLE `send_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `date` date DEFAULT NULL,
  `message` text DEFAULT NULL,
  `visible_student` varchar(10) NOT NULL DEFAULT 'no',
  `visible_staff` varchar(10) NOT NULL DEFAULT 'no',
  `visible_parent` varchar(10) NOT NULL DEFAULT 'no',
  `created_by` varchar(60) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: sessions
#

DROP TABLE IF EXISTS `sessions`;

CREATE TABLE `sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (7, '2016-17', 'no', '2017-04-20 02:42:19', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (11, '2017-18', 'no', '2017-04-20 02:41:37', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (13, '2018-19', 'no', '2016-08-24 15:26:44', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (14, '2019-20', 'no', '2016-08-24 15:26:55', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (15, '2020-21', 'no', '2016-10-01 01:28:08', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (16, '2021-22', 'no', '2016-10-01 01:28:20', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (18, '2022-23', 'no', '2016-10-01 01:29:02', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (19, '2023-24', 'no', '2016-10-01 01:29:10', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (20, '2024-25', 'no', '2016-10-01 01:29:18', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (21, '2025-26', 'no', '2016-10-01 01:30:10', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (22, '2026-27', 'no', '2016-10-01 01:30:18', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (23, '2027-28', 'no', '2016-10-01 01:30:24', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (24, '2028-29', 'no', '2016-10-01 01:30:30', '0000-00-00 00:00:00');
INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES (25, '2029-30', 'no', '2016-10-01 01:30:37', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: sms_config
#

DROP TABLE IF EXISTS `sms_config`;

CREATE TABLE `sms_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `api_id` varchar(100) NOT NULL,
  `authkey` varchar(100) NOT NULL,
  `senderid` varchar(100) NOT NULL,
  `contact` text DEFAULT NULL,
  `username` varchar(150) DEFAULT NULL,
  `url` varchar(150) DEFAULT NULL,
  `password` varchar(150) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'disabled',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: source
#

DROP TABLE IF EXISTS `source`;

CREATE TABLE `source` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: staff
#

DROP TABLE IF EXISTS `staff`;

CREATE TABLE `staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(200) NOT NULL,
  `department` varchar(100) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `qualification` varchar(200) NOT NULL,
  `work_exp` varchar(200) NOT NULL,
  `name` varchar(200) NOT NULL,
  `surname` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact_no` varchar(200) NOT NULL,
  `emergency_contact_no` varchar(200) NOT NULL,
  `email` varchar(200) NOT NULL,
  `dob` date NOT NULL,
  `marital_status` varchar(100) NOT NULL,
  `date_of_joining` date NOT NULL,
  `date_of_leaving` date NOT NULL,
  `local_address` varchar(300) NOT NULL,
  `permanent_address` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  `image` varchar(200) NOT NULL,
  `password` varchar(250) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `account_title` varchar(200) NOT NULL,
  `bank_account_no` varchar(200) NOT NULL,
  `bank_name` varchar(200) NOT NULL,
  `ifsc_code` varchar(200) NOT NULL,
  `bank_branch` varchar(100) NOT NULL,
  `payscale` varchar(200) NOT NULL,
  `basic_salary` varchar(200) NOT NULL,
  `epf_no` varchar(200) NOT NULL,
  `contract_type` varchar(100) NOT NULL,
  `shift` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `facebook` varchar(200) NOT NULL,
  `twitter` varchar(200) NOT NULL,
  `linkedin` varchar(200) NOT NULL,
  `instagram` varchar(200) NOT NULL,
  `resume` varchar(200) NOT NULL,
  `joining_letter` varchar(200) NOT NULL,
  `resignation_letter` varchar(200) NOT NULL,
  `other_document_name` varchar(200) NOT NULL,
  `other_document_file` varchar(200) NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `verification_code` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_id` (`employee_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `staff` (`id`, `employee_id`, `department`, `designation`, `qualification`, `work_exp`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`) VALUES (1, '', '', '', '', '', 'Super Admin', '', '', '', '', '', 'destinymkd@gmail.com', '0000-00-00', '', '0000-00-00', '0000-00-00', '', '', '', '', '$2y$10$xC49vw43u5zvG4AKB44JNuFZEmDPU5eT.oJLSX.685mXhrbHpJjES', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 1, '');
INSERT INTO `staff` (`id`, `employee_id`, `department`, `designation`, `qualification`, `work_exp`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`) VALUES (2, '001', '1', '1', '', '', 'Exam', 'Officer', 'Destiny', 'International', '08102607355', '', 'examofficer.destinymkd@gmail.com', '1989-11-29', '', '2020-04-29', '0000-00-00', '', '', '', '', '$2y$10$VVNgPHKNFTGVuv8PoVAqDOnTL2tEPaEp76v4dLoKbH8Y6F1Rhybtq', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Other Document', '', 0, 1, '');


#
# TABLE STRUCTURE FOR: staff_attendance
#

DROP TABLE IF EXISTS `staff_attendance`;

CREATE TABLE `staff_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `staff_id` int(11) NOT NULL,
  `staff_attendance_type_id` int(11) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: staff_attendance_type
#

DROP TABLE IF EXISTS `staff_attendance_type`;

CREATE TABLE `staff_attendance_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `key_value` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Late', '<b class=\"text text-warning\">L</b>', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Absent', '<b class=\"text text-danger\">A</b>', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Half Day', '<b class=\"text text-warning\">F</b>', 'yes', '2018-05-06 21:56:16', '0000-00-00 00:00:00');
INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: staff_designation
#

DROP TABLE IF EXISTS `staff_designation`;

CREATE TABLE `staff_designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `designation` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `staff_designation` (`id`, `designation`, `is_active`) VALUES (1, 'EXAM OFFICER', 'yes');


#
# TABLE STRUCTURE FOR: staff_leave_details
#

DROP TABLE IF EXISTS `staff_leave_details`;

CREATE TABLE `staff_leave_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `leave_type_id` int(11) NOT NULL,
  `alloted_leave` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: staff_leave_request
#

DROP TABLE IF EXISTS `staff_leave_request`;

CREATE TABLE `staff_leave_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `leave_type_id` int(11) NOT NULL,
  `leave_from` date NOT NULL,
  `leave_to` date NOT NULL,
  `leave_days` int(11) NOT NULL,
  `employee_remark` varchar(200) NOT NULL,
  `admin_remark` varchar(200) NOT NULL,
  `status` varchar(100) NOT NULL,
  `applied_by` varchar(200) NOT NULL,
  `document_file` varchar(200) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: staff_payroll
#

DROP TABLE IF EXISTS `staff_payroll`;

CREATE TABLE `staff_payroll` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_salary` int(11) NOT NULL,
  `pay_scale` varchar(200) NOT NULL,
  `grade` varchar(50) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: staff_payslip
#

DROP TABLE IF EXISTS `staff_payslip`;

CREATE TABLE `staff_payslip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `basic` int(11) NOT NULL,
  `total_allowance` int(11) NOT NULL,
  `total_deduction` int(11) NOT NULL,
  `leave_deduction` int(11) NOT NULL,
  `tax` varchar(200) NOT NULL,
  `net_salary` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  `month` varchar(200) NOT NULL,
  `year` varchar(200) NOT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `payment_date` date NOT NULL,
  `remark` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: staff_roles
#

DROP TABLE IF EXISTS `staff_roles`;

CREATE TABLE `staff_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 7, 1, 0, '2019-02-14 06:04:12', '0000-00-00 00:00:00');
INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 2, 2, 0, '2022-11-24 05:06:51', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: staff_timeline
#

DROP TABLE IF EXISTS `staff_timeline`;

CREATE TABLE `staff_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` date NOT NULL,
  `description` varchar(300) NOT NULL,
  `document` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_attendences
#

DROP TABLE IF EXISTS `student_attendences`;

CREATE TABLE `student_attendences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `attendence_type_id` int(11) DEFAULT NULL,
  `remark` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `attendence_type_id` (`attendence_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_doc
#

DROP TABLE IF EXISTS `student_doc`;

CREATE TABLE `student_doc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `doc` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_fees
#

DROP TABLE IF EXISTS `student_fees`;

CREATE TABLE `student_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) DEFAULT NULL,
  `feemaster_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `amount_discount` float(10,2) NOT NULL,
  `amount_fine` float(10,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `date` date DEFAULT '0000-00-00',
  `payment_mode` varchar(50) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_fees_deposite
#

DROP TABLE IF EXISTS `student_fees_deposite`;

CREATE TABLE `student_fees_deposite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_fees_master_id` int(11) DEFAULT NULL,
  `fee_groups_feetype_id` int(11) DEFAULT NULL,
  `amount_detail` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_fees_master_id` (`student_fees_master_id`),
  KEY `fee_groups_feetype_id` (`fee_groups_feetype_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_fees_discounts
#

DROP TABLE IF EXISTS `student_fees_discounts`;

CREATE TABLE `student_fees_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) DEFAULT NULL,
  `fees_discount_id` int(11) DEFAULT NULL,
  `status` varchar(20) DEFAULT 'assigned',
  `payment_id` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `fees_discount_id` (`fees_discount_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_fees_master
#

DROP TABLE IF EXISTS `student_fees_master`;

CREATE TABLE `student_fees_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `student_session_id` int(11) DEFAULT NULL,
  `fee_session_group_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `fee_session_group_id` (`fee_session_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_session
#

DROP TABLE IF EXISTS `student_session`;

CREATE TABLE `student_session` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `route_id` int(11) NOT NULL,
  `hostel_room_id` int(11) NOT NULL,
  `vehroute_id` int(10) DEFAULT NULL,
  `transport_fees` float(10,2) NOT NULL DEFAULT 0.00,
  `fees_discount` float(10,2) NOT NULL DEFAULT 0.00,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=312 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (102, 16, 101, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-02 05:59:56', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (103, 16, 102, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-02 06:03:22', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (104, 16, 103, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-02 06:08:18', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (105, 16, 104, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-02 06:12:14', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (106, 16, 105, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-02 06:16:54', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (107, 16, 106, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-02 06:20:14', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (108, 16, 107, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-02 06:23:07', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (109, 16, 108, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-03 04:18:14', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (110, 16, 109, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 02:31:01', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (111, 16, 110, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 02:35:06', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (112, 16, 111, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 02:39:09', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (113, 16, 112, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 02:45:06', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (114, 16, 113, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 02:50:29', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (115, 16, 114, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 02:55:09', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (116, 16, 115, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 02:58:46', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (117, 16, 116, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 03:01:47', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (118, 16, 117, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 03:05:45', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (119, 16, 118, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-05 03:11:26', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (120, 16, 119, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 10:48:43', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (121, 16, 120, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 10:52:19', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (122, 16, 121, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:00:11', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (123, 16, 122, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:03:24', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (124, 16, 123, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:10:17', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (125, 16, 124, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:10:59', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (126, 16, 125, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:14:07', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (127, 16, 126, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:20:05', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (128, 16, 127, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:30:47', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (129, 16, 128, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:35:46', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (130, 16, 129, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:39:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (131, 16, 130, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:39:23', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (132, 16, 131, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:42:26', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (133, 16, 132, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:48:05', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (134, 16, 133, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:49:16', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (135, 16, 134, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:54:48', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (136, 16, 135, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 11:59:54', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (137, 16, 136, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:05:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (138, 16, 137, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:07:47', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (139, 16, 138, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:22:17', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (140, 16, 139, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:31:04', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (141, 16, 140, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:41:59', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (142, 16, 141, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:47:27', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (143, 16, 142, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:50:30', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (144, 16, 143, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:54:10', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (145, 16, 144, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 12:57:43', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (146, 16, 145, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:01:37', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (147, 16, 146, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:04:47', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (148, 16, 147, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:08:44', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (149, 16, 148, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:12:37', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (150, 16, 149, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:16:45', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (151, 16, 150, 1, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:35:13', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (152, 16, 151, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:29:08', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (153, 16, 152, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:32:49', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (154, 16, 153, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:45:15', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (155, 16, 154, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:51:05', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (156, 16, 155, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:55:23', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (157, 16, 156, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 13:56:24', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (158, 16, 157, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:00:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (159, 16, 158, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:06:01', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (160, 16, 159, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:08:02', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (161, 16, 160, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:13:26', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (162, 16, 161, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:19:34', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (163, 16, 162, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:24:00', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (164, 16, 163, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:24:18', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (165, 16, 164, 1, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:30:30', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (166, 16, 165, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:34:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (167, 16, 166, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:34:34', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (168, 16, 167, 1, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:39:33', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (169, 16, 168, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:43:26', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (170, 16, 169, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:47:39', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (171, 16, 170, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:52:59', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (172, 16, 171, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 14:56:46', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (173, 16, 172, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:01:49', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (174, 16, 173, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:05:33', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (175, 16, 174, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:08:26', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (176, 16, 175, 1, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:13:56', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (177, 16, 176, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:14:46', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (178, 16, 177, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:17:34', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (179, 16, 178, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:20:29', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (180, 16, 179, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:28:05', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (181, 16, 180, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:31:04', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (182, 16, 181, 1, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:33:57', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (183, 16, 182, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:36:58', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (184, 16, 183, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:40:11', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (185, 16, 184, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:40:23', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (186, 16, 185, 2, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 15:43:45', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (187, 16, 186, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:11:34', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (188, 16, 187, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:15:02', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (189, 16, 188, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:20:28', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (190, 16, 189, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:24:44', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (191, 16, 190, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:28:16', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (192, 16, 191, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:32:16', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (193, 16, 192, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:36:07', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (194, 16, 193, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:45:59', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (195, 16, 194, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 16:46:50', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (196, 16, 195, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 17:00:44', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (197, 16, 196, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 17:04:02', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (198, 16, 197, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 17:07:40', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (199, 16, 198, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 17:10:29', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (200, 16, 199, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 17:13:55', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (201, 16, 200, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 17:18:10', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (202, 16, 201, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:05:49', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (203, 16, 202, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:10:01', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (204, 16, 203, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:14:19', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (205, 16, 204, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:15:40', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (206, 16, 205, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:18:28', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (207, 16, 206, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:22:30', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (208, 16, 207, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:22:59', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (209, 16, 208, 1, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 06:59:31', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (210, 16, 209, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:30:49', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (211, 16, 210, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:34:41', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (212, 16, 211, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:35:00', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (213, 16, 212, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:39:06', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (214, 16, 213, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:43:58', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (215, 16, 214, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:44:32', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (216, 16, 215, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:47:55', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (217, 16, 216, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:52:04', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (218, 16, 217, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:53:45', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (219, 16, 218, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-07 23:56:50', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (220, 16, 219, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:01:56', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (221, 16, 220, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:02:56', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (222, 16, 221, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:07:12', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (223, 16, 222, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:11:11', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (224, 16, 223, 3, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:15:17', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (225, 16, 224, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:28:50', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (226, 16, 225, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:30:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (227, 16, 226, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:33:58', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (228, 16, 227, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:38:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (229, 16, 228, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:41:54', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (230, 16, 229, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:42:11', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (231, 16, 230, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:17:03', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (232, 16, 231, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:50:06', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (233, 16, 232, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:53:35', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (234, 16, 233, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 00:56:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (235, 16, 234, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:00:22', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (236, 16, 235, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:03:14', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (237, 16, 236, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:05:17', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (238, 16, 237, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:08:59', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (239, 16, 238, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:11:51', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (240, 16, 239, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:14:31', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (241, 16, 240, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:15:03', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (242, 16, 241, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:17:59', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (243, 16, 242, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:21:30', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (244, 16, 243, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:24:06', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (245, 16, 244, 4, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:27:12', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (246, 16, 245, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:40:02', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (247, 16, 246, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 01:46:44', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (248, 16, 247, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 04:01:38', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (249, 16, 248, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 11:26:18', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (250, 16, 249, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 11:35:54', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (251, 16, 250, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 11:38:26', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (252, 16, 251, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 11:49:39', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (253, 16, 252, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (254, 16, 253, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:18:06', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (255, 16, 254, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:22:15', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (256, 16, 255, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:26:50', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (257, 16, 256, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:30:22', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (258, 16, 257, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:31:14', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (259, 16, 258, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:34:45', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (260, 16, 259, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:44:41', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (261, 16, 260, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:48:38', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (262, 16, 261, 5, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:51:42', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (263, 16, 262, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 12:56:46', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (264, 16, 263, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:00:02', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (265, 16, 264, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:02:36', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (266, 16, 265, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:05:51', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (267, 16, 266, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:09:08', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (268, 16, 267, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:19:24', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (269, 16, 268, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:21:58', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (270, 16, 269, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:25:25', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (271, 16, 270, 6, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:28:16', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (272, 16, 271, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:32:04', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (273, 16, 272, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:36:05', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (274, 16, 273, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:41:33', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (275, 16, 274, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:46:33', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (276, 16, 275, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:47:55', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (277, 16, 276, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:51:38', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (278, 16, 277, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 13:57:13', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (279, 16, 278, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:00:51', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (280, 16, 279, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:02:20', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (281, 16, 280, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:05:24', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (282, 16, 281, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:09:19', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (283, 16, 282, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:12:16', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (284, 16, 283, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:14:32', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (285, 16, 284, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:14:39', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (286, 16, 285, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:18:11', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (287, 16, 286, 7, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:20:25', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (288, 16, 287, 8, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:26:58', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (289, 16, 288, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:28:24', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (290, 16, 289, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:29:29', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (291, 16, 290, 8, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:29:51', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (292, 16, 291, 8, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:32:23', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (293, 16, 292, 8, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:37:33', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (294, 16, 293, 8, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:42:01', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (295, 16, 294, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:46:21', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (296, 16, 295, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:46:25', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (297, 16, 296, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-08 14:56:54', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (298, 16, 297, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 00:50:32', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (299, 16, 298, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 01:01:06', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (300, 16, 299, 10, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 01:10:37', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (301, 16, 300, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 05:03:10', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (302, 16, 301, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 05:11:42', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (303, 16, 302, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 05:16:43', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (304, 16, 303, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 05:22:54', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (305, 16, 304, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 05:27:10', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (306, 16, 305, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 05:33:24', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (307, 16, 306, 13, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 05:38:30', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (308, 16, 307, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 06:31:05', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (309, 16, 308, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 06:34:19', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (310, 16, 309, 11, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 06:41:03', '0000-00-00 00:00:00');
INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES (311, 16, 310, 14, 1, 0, 0, NULL, '0.00', '0.00', 'no', '2022-12-09 07:13:03', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: student_sibling
#

DROP TABLE IF EXISTS `student_sibling`;

CREATE TABLE `student_sibling` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `sibling_student_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_timeline
#

DROP TABLE IF EXISTS `student_timeline`;

CREATE TABLE `student_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` date NOT NULL,
  `description` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: student_transport_fees
#

DROP TABLE IF EXISTS `student_transport_fees`;

CREATE TABLE `student_transport_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `amount_discount` float(10,2) NOT NULL,
  `amount_fine` float(10,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `date` date DEFAULT '0000-00-00',
  `is_active` varchar(255) DEFAULT 'no',
  `payment_mode` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: students
#

DROP TABLE IF EXISTS `students`;

CREATE TABLE `students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `admission_no` varchar(100) DEFAULT NULL,
  `roll_no` varchar(100) DEFAULT NULL,
  `admission_date` varchar(100) DEFAULT '1971-01-01',
  `firstname` varchar(100) DEFAULT NULL,
  `lastname` varchar(100) DEFAULT NULL,
  `rte` varchar(20) NOT NULL DEFAULT 'No',
  `image` varchar(100) DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `pincode` varchar(100) DEFAULT NULL,
  `religion` varchar(100) DEFAULT NULL,
  `cast` varchar(50) NOT NULL,
  `dob` varchar(100) NOT NULL DEFAULT '1971-01-01',
  `gender` varchar(100) DEFAULT NULL,
  `current_address` text DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `category_id` varchar(100) DEFAULT NULL,
  `route_id` int(11) NOT NULL,
  `school_house_id` int(11) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `vehroute_id` int(11) NOT NULL,
  `hostel_room_id` int(11) NOT NULL,
  `adhar_no` varchar(100) DEFAULT NULL,
  `samagra_id` varchar(100) DEFAULT NULL,
  `bank_account_no` varchar(100) DEFAULT NULL,
  `bank_name` varchar(100) DEFAULT NULL,
  `ifsc_code` varchar(100) DEFAULT NULL,
  `guardian_is` varchar(100) DEFAULT 'other',
  `father_name` varchar(100) DEFAULT NULL,
  `father_phone` varchar(100) DEFAULT NULL,
  `father_occupation` varchar(100) DEFAULT NULL,
  `mother_name` varchar(100) DEFAULT NULL,
  `mother_phone` varchar(100) DEFAULT NULL,
  `mother_occupation` varchar(100) DEFAULT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `guardian_relation` varchar(100) DEFAULT NULL,
  `guardian_phone` varchar(100) DEFAULT NULL,
  `guardian_occupation` varchar(150) NOT NULL,
  `guardian_address` text DEFAULT NULL,
  `guardian_email` varchar(100) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `guardian_pic` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `previous_school` text DEFAULT NULL,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `measurement_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `disable_at` date NOT NULL,
  `note` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (101, 2, '111', '001', '2022-12-02', 'Abdulmalik', 'Habeeb', 'No', 'uploads/student_images/no_image.png', '07032057132', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', 'Male', '2008-12-27', 'Male', 'number 18 Udei street Northbank Makurdi', 'number 18 Udei street Northbank Makurdi', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Abdulmalik', '07032057132', 'Driver', '', '07032057132', '07032057132', 'Abdulmalik', 'Father', '07032057132', 'Driver', 'number 18 Udei street Northbank Makurdi', '', '', '', '', 'yes', '', '4', '4', '2022-12-02', '2022-12-06 15:35:16', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (102, 4, '112', '002', '2022-12-02', 'Abu', 'Musa', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Muslim', '', '2015-05-05', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Musa', '08102215118', 'Teacher', '', '', '', 'Musa', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '3', '5', '2022-12-02', '2022-12-06 15:39:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (103, 6, '113', '003', '2022-12-02', 'Adah', 'Samuel', 'No', 'uploads/student_images/no_image.png', '07036409610', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2009-12-22', 'Male', 'Number 2 Eri street Northbank', 'Number 2 Eri street Northbank', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Adah', '07036409610', 'Civil worker', '', '', '', 'Adah', 'Father', '07036409610', 'Civi worker', 'Number 2 Eri street Northbank', '', '', '', '', 'yes', '', '12', '28', '2022-12-02', '2022-12-06 15:48:52', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (104, 8, '114', '023', '2022-12-02', 'Adamu', 'Hajara', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlionusgmail.com', NULL, NULL, NULL, 'Muslim', '', '2022-06-07', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Adamu', '08059855131', 'Teacher', '', '', '', 'Adamu', 'Father', '08059855131', 'Teacher', '', '', '', '', '', 'yes', '', '5', '4', '2022-12-02', '2022-12-09 06:07:04', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (105, 10, '115', '019', '2022-12-02', 'Adawun', 'Bitrus', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2022-08-09', 'Male', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Adawun', '08102215118', 'Farmer', '', '', '', 'Adawun', 'Father', '08102215118', 'Farmer', '', '', '', '', '', 'yes', '', '4', '7', '2022-12-02', '2022-12-09 06:08:58', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (106, 12, '116', '004', '2022-12-02', 'Amadi', 'Mark', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-10-04', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Amadi', '08102607355', 'Policeman', '', '', '', 'Amadi', 'Father', '08102607355', 'Policeman', '', '', '', '', '', 'yes', '', '5', '7', '2022-12-02', '2022-12-09 06:09:55', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (107, 14, '117', '005', '2022-12-02', 'Amough', 'Barnabas', 'No', 'uploads/student_images/no_image.png', '08102607355', '', NULL, NULL, NULL, 'Christain', '', '2022-07-12', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Amough', '08102607355', 'Trader', '', '', '', 'Amough', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '6', '5', '2022-12-02', '2022-12-09 06:11:37', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (108, 16, '119', '006', '2022-12-03', 'Asemakah', 'Samson', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2022-08-02', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Asemakah', '08102215118', 'Farmer', '', '', '', 'Asemakah', 'Father', '08102215118', 'Farmer', '', '', '', '', '', 'yes', '', '5', '7', '2022-12-03', '2022-12-09 06:13:23', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (109, 18, '120', '022', '2022-12-05', 'Ayangeror', 'Fanani', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-07-04', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ayangeror', '08102607355', 'Teacher', '', '', '', 'Ayangeror', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '15', '11', '2022-12-05', '2022-12-09 06:14:54', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (110, 20, '121', '024', '2022-12-05', 'Azaaaondo', 'Janet', 'No', 'uploads/student_images/no_image.png', '08102607355', 'PiusOchigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-01-05', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Azaaondo', '08102607355', '', '', '', '', 'Azaaondo', 'Father', '08102607355', '', '', '', '', '', '', 'yes', '', '12', '10', '2022-12-05', '2022-12-09 06:16:55', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (111, 22, '122', '007', '2022-12-05', 'Micheal', 'Bitrus', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephllionus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Micheal', '08102215118', '', '', '', '', 'Micheal', 'Father', '08102215118', '', '', '', '', '', '', 'yes', '', '12', '15', '2022-12-05', '2022-12-09 06:17:57', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (112, 24, '123', '025', '2022-12-05', 'Clement', 'Ochanya', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2022-07-11', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Clement', '08102215118', 'Teacher', '', '', '', 'Clement', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '10', '22', '2022-12-05', '2022-12-09 06:03:07', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (113, 26, '124', '20', '2022-12-05', 'Sunday', 'Donald', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2022-08-09', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Donald', '08102607355', 'Teacher', '', '', '', 'Donald', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '22', '11', '2022-12-05', '2022-12-09 06:19:03', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (114, 28, '125', '008', '2022-12-05', 'Eche', 'Emmanuel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-20', 'Male', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Eche', '08102607355', 'farmer', '', '', '', 'Eche', 'Father', '08102607355', 'farmer', '', '', '', '', '', 'yes', '', '15', '20', '2022-12-05', '2022-12-09 06:20:03', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (115, 30, '126', '026', '2022-12-05', 'Eche', 'Emmanuella', 'No', 'uploads/student_images/no_image.png', '08102607355', 'PiusOchigbogmail.com', NULL, NULL, NULL, 'Cristain', '', '2022-08-16', 'Female', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Eche', '08102607355', 'Teacher', '', '', '', 'Eche', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '10', '23', '2022-12-05', '2022-12-09 06:20:50', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (116, 32, '160', '41', '2022-12-05', 'Terfa', 'Doose', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbo.gmail', NULL, NULL, NULL, 'Christain', '', '2022-08-09', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Terfa', '08102607355', 'Teacher', '', '', '', 'Terfa', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '10', '22', '2022-12-05', '2022-12-05 03:01:47', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (117, 34, '128', '009', '2022-12-05', 'Godspower', 'Alex', 'No', 'uploads/student_images/no_image.png', '08102607355', 'PiusOchigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-08-02', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Godspower', '08102607355', 'Teacher', '', '', '', 'Godspower', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '12', '15', '2022-12-05', '2022-12-09 06:23:18', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (118, 36, '129', '010', '2022-12-05', 'Godspower', 'Godbless', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Cristain', '', '2022-12-06', 'Male', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Godspower', '08102607355', 'Farmer', '', '', '', 'Godspower', 'Father', '08102607355', 'Farmer', '', '', '', '', '', 'yes', '', '15', '10', '2022-12-05', '2022-12-09 06:24:29', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (119, 38, '131', '031', '2022-12-07', 'Igbudu', 'Monica', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-05', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Igbudu', '08102607355', 'business man', '', '', '', 'Igbudu', 'Father', '08102607355', 'business man', '', '', '', '', '', 'yes', '', '11', '20', '2022-12-07', '2022-12-07 10:48:43', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (120, 40, '132', '030', '2022-12-07', 'Inalegwu', 'Blessing', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-02-14', 'Female', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Inalegwu', '08102607355', 'Civil servant', '', '', '', 'Inalegwu', 'Father', '08102607355', 'Civil servant', '', '', '', '', '', 'yes', '', '12', '25', '2022-12-07', '2022-12-07 10:52:19', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (121, 42, '133', '012', '2022-12-07', 'Isah', 'Muhammed', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephliusgmail.com', NULL, NULL, NULL, 'Muslim', '', '2022-04-05', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Isah', '08102215118', 'Teacher', '', '', '', 'Isah', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '12', '15', '2022-12-07', '2022-12-07 11:00:11', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (122, 44, '134', '028', '2022-12-07', 'Isuwa', 'Esther', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2022-07-12', 'Female', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Isuwa', '08102215118', 'Business man', '', '', '', 'Isuwa', 'Father', '08102215118', 'Business man', 'Eri number 4 North bank', '', '', '', '', 'yes', '', '15', '25', '2022-12-07', '2022-12-07 11:03:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (123, 46, '135', '029', '2022-12-07', 'Isyaku', 'Shamsiuya', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmai', NULL, NULL, NULL, 'Muslim', '', '2022-03-14', 'Female', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Isyaku', '08102215118', 'Teacher', '', '', '', 'Isyaku', 'Father', '08102215118', 'Teacher', 'number 10 dayspring north bank', '', '', '', '', 'yes', '', '15', '20', '2022-12-07', '2022-12-07 11:10:17', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (124, 48, '157', '18', '2022-12-07', 'Ameh', 'Margaret Ekum', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2010-01-04', 'Female', '', '', '3', 0, 0, 'O-', 0, 0, '', '', '', '', '', 'father', 'Ameh', '08102607355', 'Civil Servant', 'Victoria', '08102607355', 'Teaching', 'Ameh', 'Father', '08102607355', 'Civil Servant', '15  Eri Street, North Bank ,Makurdi', '', '', '', '', 'yes', '', '12', '23', '2022-12-07', '2022-12-08 15:12:18', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (125, 50, '136', '032', '2022-12-07', 'Jubril', 'Maryam', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmaim.com', NULL, NULL, NULL, 'Muslim', '', '2022-03-14', 'Female', '', '', '3', 0, 0, 'B+', 0, 0, '', '', '', '', '', 'father', 'Jubril', '08102215118', 'driver', '', '', '', 'Jubril', 'Father', '08102215118', 'driver', ' number 20 Udei street northbank', '', '', '', '', 'yes', '', '17', '25', '2022-12-07', '2022-12-07 11:14:07', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (126, 52, '137', '033', '2022-12-07', 'Kalu', 'Chisom', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2021-04-06', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Kalu', '08102215118', '08102215118', '', '', '', 'Kalu', 'Father', '08102215118', '08102215118', 'number 14 mechanic village', '', '', '', '', 'yes', '', '24', '14', '2022-12-07', '2022-12-09 06:05:18', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (127, 54, '138', '021', '2022-12-07', 'Sule', 'Kelvin', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-07-05', 'Male', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Sule', '08102607355', 'Business man', '', '', '', 'Sule', 'Father', '08102607355', 'Business man', 'Eri 3 street northbank  ', '', '', '', '', 'yes', '', '16', '25', '2022-12-07', '2022-12-07 11:30:47', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (128, 56, '139', '044', '2022-12-07', 'Kuma', 'Blessing', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-11-16', 'Female', '', '', '3', 0, 0, 'AB+', 0, 0, '', '', '', '', '', 'father', 'Kuma', '08102607355', 'Businessman', '', '', '', 'Kuma', 'Father', '08102607355', 'Businessman', ' number 2 Lafia garge', '', '', '', '', 'yes', '', '18', '15', '2022-12-07', '2022-12-09 06:43:32', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (129, 58, '141', '034', '2022-12-07', 'Laisi', 'Godwin', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-05-11', 'Male', '', '', '3', 0, 0, 'AB+', 0, 0, '', '', '', '', '', 'father', 'Laisi', '08102607355', 'Businessman', '', '', '', 'Laisi', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 11:39:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (130, 60, '158', '19', '2022-12-07', 'Musa', 'Amina', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-01-01', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Musa', '08102607355', 'Civil servant', 'Victoria', '08102607355', 'farming', 'Musa', 'Father', '08102607355', 'Civil servant', '15 Eri Str,NorthBank Market', '', '', '', '', 'yes', '', '32', '23', '2022-12-07', '2022-12-08 15:14:23', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (131, 62, '142', '016', '2022-12-07', 'Laisi', 'Grace', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2022-01-12', 'Female', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Laisi', '08102215118', 'Teacher', '', '', '', 'Laisi', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '15', '20', '2022-12-07', '2022-12-07 11:42:26', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (132, 64, '143', '013', '2022-12-07', 'Moshood', 'Abdul', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Christain', '', '2021-02-11', 'Male', '', '', '3', 0, 0, 'AB+', 0, 0, '', '', '', '', '', 'father', 'Moshood', '08102215118', 'driver', '', '', '', 'Moshood', 'Father', '08102215118', 'driver', ' number 15 Udei street northbank', '', '', '', '', 'yes', '', '17', '15', '2022-12-07', '2022-12-07 11:48:05', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (133, 66, '159', '20', '2022-12-07', 'Aondona', 'Rejoice', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2013-04-01', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Aondona', '08102607355', 'Civil Servant', 'Victoria', '08102607355', 'Farming', 'Aondona', 'Father', '08102607355', 'Civil Servant', '15 Eri Str, North Bank,Makurdi', '', '', '', '', 'yes', '', '5', '22', '2022-12-07', '2022-12-09 05:15:27', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (134, 68, '144', '037', '2022-12-07', 'Muhammed', 'Esther', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jeplinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-11-10', 'Female', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Muhammed', '08102215118', 'Teacher', '', '', '', 'Muhammed', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '13', '17', '2022-12-07', '2022-12-07 11:54:48', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (135, 70, '145', '035', '2022-12-07', 'Musa', 'Hope', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118 gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-03-10', 'Female', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Musa', '08102215118', 'Teacher', '', '', '', 'Musa', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '25', '15', '2022-12-07', '2022-12-07 11:59:54', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (136, 72, '146', '036', '2022-12-07', 'Musa', 'Zelia', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.com', NULL, NULL, NULL, 'Christain', '', '2021-02-10', 'Female', '', '', '3', 0, 0, 'B+', 0, 0, '', '', '', '', '', 'father', 'Musa', '08102215118', 'Teacher', '', '', '', 'Musa', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '21', '17', '2022-12-07', '2022-12-07 12:05:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (137, 74, '160', '1', '2022-12-07', 'Ayigbese', 'Ishaku', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2017-06-26', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ayigbese', '08102607355', 'Fishing', 'victoria', '08102607355', 'Fishing', 'Ayigbese', 'Father', '08102607355', 'Fishing', '15Eri Str NorthBank,Makurdi', '', '', '', '', 'yes', '', '1232', '', '2022-12-07', '2022-12-09 05:17:16', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (138, 76, '161', '36', '2022-12-07', 'Azetu', 'Awanini', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2002-02-05', 'Female', '', '', '3', 0, 0, 'AB+', 0, 0, '', '', '', '', '', 'father', 'Awanin', '08102607355', 'Fishing', 'Victoria', '08102607355', '', 'Awanin', 'Father', '08102607355', 'Fishing', '15 Eri Str , NorthBank', '', '', '', '', 'yes', '', '12', '23', '2022-12-07', '2022-12-09 05:18:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (139, 78, '147', '038', '2022-12-07', 'Nnamani', 'Rita', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-02-17', 'Female', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Nnamani', '08102607355', 'Teacher', '', '', '', 'Nnamani', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '20', '11', '2022-12-07', '2022-12-07 12:31:04', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (140, 80, '148', '042', '2022-12-07', 'Ochoja', 'Dominion', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-13', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ochoja', '08102607355', 'Civil servant', '', '', '', 'Ochoja', 'Father', '08102607355', 'Civil servant', '', '', '', '', '', 'yes', '', '20', '20', '2022-12-07', '2022-12-09 06:45:07', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (141, 82, '149', '046', '2022-12-07', 'Odenge', 'Adamu', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-10-11', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Odenge', '08102215118', 'Teacher', '', '', '', 'Odenge', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '20', '21', '2022-12-07', '2022-12-09 05:52:11', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (142, 84, '150', '014', '2022-12-07', 'Oha', 'Excellent', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-06-06', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Oha', '08102607355', 'Technician', '', '', '', 'Oha', 'Father', '08102607355', 'Technician', '', '', '', '', '', 'yes', '', '11', '23', '2022-12-07', '2022-12-09 05:50:53', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (143, 86, '151', '015', '2022-12-07', 'Saleh', 'Samson', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-13', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Saleh', '08102607355', 'Technician', '', '', '', 'Saleh', 'Father', '08102607355', 'Technician', '', '', '', '', '', 'yes', '', '50', '50', '2022-12-07', '2022-12-09 05:49:55', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (144, 88, '152', '039', '2022-12-07', 'Sunday', 'Mimidoo', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-03-10', 'Female', 'Vertinary  Layout', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Sunday', '08102607355', 'Automechanic', '', '', '', 'Sunday', 'Father', '08102607355', 'Automechanic', 'Vertinary  Layout', '', '', '', '', 'yes', '', '30', '32', '2022-12-07', '2022-12-09 05:48:12', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (145, 90, '153', '040', '2022-12-07', 'Sunday', 'Wuester', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2020-03-04', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Sunday', '08059855131', 'Businessman', '', '', '', 'Sunday', 'Father', '08059855131', 'Businessman', '', '', '', '', '', 'yes', '', '40', '35', '2022-12-07', '2022-12-09 05:53:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (146, 92, '154', '041', '2022-12-07', 'Tsafa', 'Doomen', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-09-14', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Tsafa', '08102215118', 'Driver', '', '', '', 'Tsafa', 'Father', '08102215118', 'Driver', '', '', '', '', '', 'yes', '', '6', '23', '2022-12-07', '2022-12-09 05:54:17', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (147, 94, '155', '018', '2022-12-07', 'Yakubu', 'Kalifa', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbo.gmail.com', NULL, NULL, NULL, 'Muslim', '', '2022-12-20', 'Male', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Yakubu', '08102607355', 'Teacher', '', '', '', 'Yakubu', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-09 05:55:10', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (148, 96, '156', '017', '2022-12-07', 'Yunana', ' A Monday', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-27', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', ' Mr Yunana', '08102215118', 'Businessman', '', '', '', 'Mr Yunana', 'Father', '08102215118', 'Businessman', '', '', '', '', '', 'yes', '', '17', '77', '2022-12-07', '2022-12-09 05:56:39', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (149, 98, '140', '045', '2022-12-07', 'Kuma', 'Goodluck', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-11-27', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Kuma', '08059855131', 'Artisian', '', '', '', 'Kuma', 'Father', '08059855131', 'Artisian', '', '', '', '', '', 'yes', '', '20', '30', '2022-12-07', '2022-12-09 05:57:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (150, 100, '001', '010', '2022-12-07', 'Abdulawal', 'Asumawu', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2021-10-06', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Abdulawal', '08102607355', 'Businessmam', '', '', '', 'Abdulawal', 'Father', '08102607355', 'Businessmam', '', '', '', '', '', 'yes', '', '12', '15', '2022-12-07', '2022-12-07 13:24:13', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (151, 102, '002', '002', '2022-12-07', 'Agbo', 'Joy', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-04-06', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Agbo', '08102607355', 'Transporter', '', '', '', 'Agbo', 'Father', '08102607355', 'Transporter', '', '', '', '', '', 'yes', '', '15', '31', '2022-12-07', '2022-12-07 13:29:08', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (152, 104, '003', '011', '2022-12-07', 'Aminu', 'Rahmat', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2021-08-03', 'Female', '', '', '1', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Aminu', '08102607355', 'Businessman', '', '', '', 'Aminu', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '11', '13', '2022-12-07', '2022-12-07 13:32:49', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (153, 106, '004', '001', '2022-12-07', 'Amougy', 'Joseph', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusochigbogmail.gmail', NULL, NULL, NULL, 'Christain', '', '2021-01-05', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Amougy', '08102607355', 'Teacher', '', '', '', 'Amougy', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '32', '45', '2022-12-07', '2022-12-07 13:45:15', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (154, 108, '005', '003', '2022-12-07', 'Chukwudi', 'David', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-09-07', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'David', '08102607355', 'Teacher', '', '', '', 'David', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '13', '15', '2022-12-07', '2022-12-07 13:51:05', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (155, 110, '162', '2', '2022-12-07', 'Benson', 'Ebenezer', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2016-01-04', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ebenezer', '08102607355', 'driving', 'victoria', '08102607355', '', 'Ebenezer', 'Father', '08102607355', 'driving', '', '15 ERI STR.,NORTH BANK', '', '', '', 'yes', '', '2', '34', '2022-12-07', '2022-12-09 05:19:47', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (156, 112, '006', '015', '2022-12-07', 'Chukwunyere', 'Chimbusomma', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-05-11', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Chimbusomma', '08102607355', 'Teacher', '', '', '', 'Chimbusomma', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '13', '35', '2022-12-07', '2022-12-07 13:56:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (157, 114, '007', '004', '2022-12-07', 'Ebele', 'Benedicta', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-07-13', 'Female', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ebele', '08102607355', 'Teacher', '', '', '', 'Ebele', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '11', '23', '2022-12-07', '2022-12-07 14:00:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (158, 116, '163', '33', '2022-12-07', 'Danjuma', 'Precious', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2018-10-09', 'Female', '', '', '3', 0, 0, 'AB-', 0, 0, '', '', '', '', '', 'father', 'Danjuma', '08102607355', 'fishing', '', '', '', 'Danjuma', 'Father', '08102607355', 'fishing', '', '', '', '', '', 'yes', '', '6', '12', '2022-12-07', '2022-12-09 05:20:51', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (159, 118, '008', '005', '2022-12-07', 'Elisha', 'Syva', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-06', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Elisha', '08102215118', 'Teacher', '', '', '', 'Elisha', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '13', '24', '2022-12-07', '2022-12-07 14:08:02', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (160, 120, '009', '006', '2022-12-07', 'Friday', 'Elisha', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-11-09', 'Male', '', '', '1', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Friday', '08102607355', 'Teacher', '', '', '', 'Friday', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '32', '45', '2022-12-07', '2022-12-07 14:13:26', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (161, 122, '010', '014', '2022-12-07', 'Hendrix', 'Angel Grace', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2019-06-04', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Hendrix', '08059855131', 'Teacher', '', '', '', 'Hendrix', 'Father', '08059855131', 'Teacher', '', '', '', '', '', 'yes', '', '34', '45', '2022-12-07', '2022-12-07 14:19:34', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (162, 124, '164', '21', '2022-12-07', 'Egere', 'Precious', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2012-10-29', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Egere', '08102607355', 'Technician', 'VICTORIA', '0812607355', 'Trading', 'Egere', 'Father', '08102607355', 'Technician', '15 Eri Str NORTH bank', '', '', '', '', 'yes', '', '21', '25', '2022-12-07', '2022-12-09 05:22:33', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (163, 126, '011', '007', '2022-12-07', 'Idam', 'Chidebere', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2020-02-04', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Idam', '08102215118', 'Teacher', '', '', '', 'Idam', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 14:24:18', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (164, 128, '012', '029', '2022-12-07', 'Ijir', 'Jemima   C', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2020-03-03', 'Female', '', '', '1', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Ijir', '08102607355', 'Teacher', '', '', '', 'Ijir', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 14:30:30', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (165, 130, '165', '3', '2022-12-07', 'Elaigwu', 'Song', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2014-09-15', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'odenge', '08102607355', 'Farming', 'victoria', '08102607355', '', 'odenge', 'Father', '08102607355', 'Farming', '15 Eri ,North Bank, North Bank', '', '', '', '', 'yes', '', '32', '42', '2022-12-07', '2022-12-09 05:23:34', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (166, 132, '013', '013', '2022-12-07', 'Ikechukwu', 'Angel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2019-06-12', 'Female', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ikechukwu', '08102607355', 'Teacher', '', '', '', 'Ikechukwu', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '20', '30', '2022-12-07', '2022-12-07 14:34:34', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (167, 134, '014', '021', '2022-12-07', 'Iyaka', 'Zarindin', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-02-10', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Iyaka', '08102607355', 'Teacher', '', '', '', 'Iyaka', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '34', '32', '2022-12-07', '2022-12-07 14:39:33', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (168, 136, '015', '028', '2022-12-07', 'Jacob', 'Ehi      Gift', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2020-01-08', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Jacob', '08102215118', 'Businessman', '', '', '', 'Jacob', 'Father', '08102215118', 'Businessman', '', '', '', '', '', 'yes', '', '23', '40', '2022-12-07', '2022-12-07 14:43:26', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (169, 138, '166', '4', '2022-12-07', 'Eze', 'C Collin', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2015-08-19', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Eze', '08102607355', 'Trading', '', '', '', 'Eze', 'Father', '08102607355', 'Trading', '15 Eri Str.North Bank,Makurdi', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-09 05:24:26', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (170, 140, '016', '016', '2022-12-07', 'Jonathan', 'Shenack  M', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbo.gmail.com', NULL, NULL, NULL, 'Christain', '', '2018-02-05', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Jonathan', '08102607355', 'Teacher', '', '', '', 'Jonathan', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '14', '45', '2022-12-07', '2022-12-07 14:52:59', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (171, 142, '017', '027', '2022-12-07', 'Kuma', 'Godwill', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2018-12-04', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Kuma', '08102215118', 'Driver', '', '', '', 'Kuma', 'Father', '08102215118', 'Driver', '', '', '', '', '', 'yes', '', '45', '35', '2022-12-07', '2022-12-07 14:56:46', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (172, 144, '018', '009', '2022-12-07', 'Mohammed', 'Abbas', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'christain', '', '2017-12-06', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Mohammed', '08102215118', 'driver', '', '', '', 'Mohammed', 'Father', '08102215118', 'driver', '', '', '', '', '', 'yes', '', '13', '34', '2022-12-07', '2022-12-07 15:01:49', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (173, 146, '019', '008', '2022-12-07', 'Mohammed', 'Saminu', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'christain', '', '2020-02-05', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Mohammed', '08059855131', 'Businessman', '', '', '', 'Mohammed', 'Father', '08059855131', 'Businessman', '', '', '', '', '', 'yes', '', '22', '22', '2022-12-07', '2022-12-07 15:05:33', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (174, 148, '020', '012', '2022-12-07', 'Nnadi', ' Joshua Chermerit', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-04-05', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Nnadi', '08059855131', 'Teacher', '', '', '', 'Nnadi', 'Father', '08059855131', 'Teacher', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 15:08:26', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (175, 150, '021', '018', '2022-12-07', 'Ochewola', 'Marvellous', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2020-08-14', 'Male', '', '', '1', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Ochewola', '08059855131', 'Technician', '', '', '', 'Ochewola', 'Father', '08059855131', 'Technician', '', '', '', '', '', 'yes', '', '33', '34', '2022-12-07', '2022-12-07 15:13:56', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (176, 152, '167', '22', '2022-12-07', 'Gani', 'JOY', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2016-07-05', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Gani', '08102607355', 'Technician', 'VICTORIA', '08102607355', '', 'Gani', 'Father', '08102607355', 'Technician', '15 Eri ,NORTH BANK , Makurdi', '', '', '', '', 'yes', '', '21', '27', '1999-12-07', '2022-12-09 05:25:12', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (177, 154, '022', '019', '2022-12-07', 'Ochoge', 'Ephraim', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Piusochigbo.gmail.com', NULL, NULL, NULL, 'Christain', '', '2020-02-12', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ochoge', '08059855131', 'Businessman', '', '', '', 'Ochoge', 'Father', '08059855131', 'Businessman', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 15:17:34', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (178, 156, '023', '020', '2022-12-07', 'Ogbo', 'Emmanuel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Jephlinus118.com', NULL, NULL, NULL, 'christain', '', '2019-08-07', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ogbo', '08102607355', 'driver', '', '', '', 'Ogbo', 'Father', '08102607355', 'driver', '', '', '', '', '', 'yes', '', '24', '32', '2022-12-07', '2022-12-07 15:20:29', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (179, 158, '024', '017', '2022-12-07', 'Onuh', 'Lawrence', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2016-12-26', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Onuh', '08102607355', 'Teacher', '', '', '', 'Onuh', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 15:28:05', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (180, 160, '025', '022', '2022-12-07', 'Tarza', 'Faith', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-12-14', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Tarza', '08102607355', 'Businessman', '', '', '', 'Tarza', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '22', '22', '2022-12-07', '2022-12-07 15:31:04', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (181, 162, '026', '024', '2022-12-07', 'Usman', 'Abdul', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Muslim', '', '2018-09-05', 'Male', '', '', '1', 0, 0, 'B+', 0, 0, '', '', '', '', '', 'father', 'Usman', '08102215118', 'Artisian', '', '', '', 'Usman', 'Father', '08102215118', 'Artisian', '', '', '', '', '', 'yes', '', '45', '45', '2022-12-07', '2022-12-07 15:33:57', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (182, 164, '027', '023', '2022-12-07', 'Usman', 'Memunatu', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Muslim', '', '2022-01-04', 'Male', '', '', '1', 0, 0, 'AB+', 0, 0, '', '', '', '', '', 'father', 'Usman', '08102215118', 'Teacher', '', '', '', 'Usman', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '11', '25', '2022-12-07', '2022-12-07 15:36:58', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (183, 166, '028', '025', '2022-12-07', 'Yahaya', 'Hafiza', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Muslim', '', '2010-02-10', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Yahaya', '08102215118', 'Teacher', '', '', '', 'Yahaya', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '14', '14', '2022-12-07', '2022-12-07 15:40:11', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (184, 168, '168', '23', '2022-12-07', 'Igwe', 'Damilola', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '1998-12-28', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Igwe', '08102607355', 'Businssman', '', '', '', 'Igwe', 'Father', '08102607355', 'Businssman', 'Eri 15 NORTH BANK', '', '', '', '', 'yes', '', '12', '42', '2022-12-07', '2022-12-09 05:26:12', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (185, 170, '029', '026', '2022-12-07', 'Yusuf', 'DanoMariya', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Muslim', '', '2019-05-07', 'Female', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Yusuf', '08102215118', '', '', '', '', 'Yusuf', 'Father', '08102215118', '', '', '', '', '', '', 'yes', '', '31', '31', '2022-12-07', '2022-12-07 15:43:45', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (186, 172, '169', '6', '2022-12-07', 'Igwe', 'Mary', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2010-05-04', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Igwe', '08102607355', 'Civil servant', '', '', '', 'Igwe', 'Father', '08102607355', 'Civil servant', '15 Eri street,North Bank, Makurdi', '', '', '', '', 'yes', '', '12', '24', '2022-12-07', '2022-12-09 05:27:34', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (187, 174, '030', '001', '2022-12-07', 'Abdul', 'Mufida', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2017-04-07', 'Female', '', '', '1', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Abdul', '08102607355', 'Trader', '', '', '', 'Abdul', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '12', '12', '2022-12-07', '2022-12-07 16:15:02', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (188, 176, '031', '002', '2022-12-07', 'Abdulkadiri', 'Rabiyatu', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2017-04-02', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Abdulkadiri', '08102607355', 'Businessman', '', '', '', 'Abdulkadiri', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '12', '12', '2022-12-07', '2022-12-07 16:20:28', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (189, 178, '032', '001', '2022-12-07', 'Abdulraziz', 'Halirat', 'No', 'uploads/student_images/no_image.png', '08160905386', 'piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2017-11-14', 'Female', '', '', '1', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Abdulraziz', '08160905386', 'Trader', '', '', '', 'Abdulraziz', 'Father', '08160905386', 'Trader', '', '', '', '', '', 'yes', '', '13', '13', '2022-12-07', '2022-12-07 16:24:44', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (190, 180, '033', '002', '2022-12-07', 'Acholo', 'Jennifer', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-05', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Acholo', '08102607355', 'Trader', '', '', '', 'Acholo', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '14', '14', '2022-12-07', '2022-12-07 16:28:16', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (191, 182, '034', '004', '2022-12-07', 'Akura', 'Mirabel', 'No', 'uploads/student_images/no_image.png', '07084755823', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2018-04-19', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Akura', '07084755823', 'Trader', '', '', '', 'Akura', 'Father', '07084755823', 'Trader', '', '', '', '', '', 'yes', '', '15', '15', '2022-12-07', '2022-12-07 16:32:16', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (192, 184, '035', '005', '2022-12-07', 'Ali', 'Mariam', 'No', 'uploads/student_images/no_image.png', '08074068066', 'Piuspchigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2019-09-16', 'Female', '', '', '1', 0, 0, 'B+', 0, 0, '', '', '', '', '', 'father', 'Ali', '08074068066', 'Trader', '', '', '', 'Ali', 'Father', '08074068066', 'Trader', '', '', '', '', '', 'yes', '', '15', '15', '2022-12-07', '2022-12-07 16:36:07', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (193, 186, '036', '006', '2022-12-07', 'Awalu', 'Lawal', 'No', 'uploads/student_images/no_image.png', '08038399696', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2017-02-24', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Awalu', '08038399696', 'Trader', '', '', '', 'Awalu', 'Father', '08038399696', 'Trader', '', '', '', '', '', 'yes', '', '23', '23', '2022-12-07', '2022-12-07 16:45:59', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (194, 188, '170', '8', '2022-12-07', 'indusor', 'JOHN', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Nigeria', '', '2008-12-29', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'indusor', '08102607355', 'fishing', 'victoria', '08102607355', '', 'indusor', 'Father', '08102607355', 'fishing', '15 EriNorth Bank,Makurdi', '', '', '', '', 'yes', '', '32', '32', '2022-12-07', '2022-12-09 05:28:58', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (195, 190, '037', '007', '2022-12-07', 'Echeija', 'Anthonia', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2018-03-22', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Echeija', '08102607355', 'Trader', '', '', '', 'Echeija', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 17:00:44', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (196, 192, '038', '009', '2022-12-07', 'Emmanuel', 'Divine Favour', 'No', 'uploads/student_images/no_image.png', '07039630087', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-03-17', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Emmanuel', '07039630087', 'Trader', '', '', '', 'Emmanuel', 'Father', '07039630087', 'Trader', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 17:04:02', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (197, 194, '039', '003', '2022-12-07', 'Godspower', 'Tare', 'No', 'uploads/student_images/no_image.png', '09022332604', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-03-27', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Godspower', '09022332604', 'Trader', '', '', '', 'Godspower', 'Father', '09022332604', 'Trader', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 17:07:40', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (198, 196, '040', '004', '2022-12-07', 'Ibrahim', 'Mohammed', 'No', 'uploads/student_images/no_image.png', '07039294039', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Muslim', '', '2016-12-06', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ibrahim', '07039294039', 'Teacher', '', '', '', 'Ibrahim', 'Father', '07039294039', 'Teacher', '', '', '', '', '', 'yes', '', '', '', '2022-12-07', '2022-12-07 17:10:29', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (199, 198, '041', '010', '2022-12-07', 'Ibrahim', 'Shaibu', 'No', 'uploads/student_images/no_image.png', '07039294029', 'Jephlinusgmail.com', NULL, NULL, NULL, 'Muslim', '', '2018-11-16', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ibrahim', '07039294039', 'trader', '', '', '', 'Ibrahim', 'Father', '07039294039', 'trader', '', '', '', '', '', 'yes', '', '20', '20', '2022-12-07', '2022-12-07 17:13:55', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (200, 200, '042', '005', '2022-12-07', 'Igwe  C', 'Mikel  Frankin', 'No', 'uploads/student_images/no_image.png', '08036177343', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2017-12-16', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Igwe     C', '08036177323', 'Trader', '', '', '', 'Igwe     C', 'Father', '08036177323', 'Trader', '', '', '', '', '', 'yes', '', '12', '12', '2022-12-07', '2022-12-07 17:18:10', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (201, 202, '043', '006', '2022-12-08', 'Ikechukwu', 'E     Solomom', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-07-02', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ikechukwu', '08102607355', 'Trader', '', '', '', 'Ikechukwu', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '21', '21', '2022-12-08', '2022-12-07 23:05:49', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (202, 204, '044', '013', '2022-12-08', 'Innocent', 'Victory', 'No', 'uploads/student_images/no_image.png', '08164405852', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-11-12', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Innocent', '08164405852', 'Trader', '', '', '', 'Innocent', 'Father', '08164405852', 'Trader', '', '', '', '', '', 'yes', '', '21', '21', '2022-12-08', '2022-12-07 23:10:01', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (203, 206, '045', '014', '2022-12-08', 'Iorpuu', 'M Doris', 'No', 'uploads/student_images/no_image.png', '07067904038', 'Jephlionus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2018-04-27', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Iorpuu', '07067904038', 'Businessman', '', '', '', 'Iorpuu', 'Father', '07067904038', 'Businessman', '', '', '', '', '', 'yes', '', '', '', '2022-12-08', '2022-12-07 23:14:19', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (204, 208, '171', '40', '2022-12-08', 'Ishaya', 'Shidomgba', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Nigeria', '', '2018-05-27', 'Female', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Ishaya', '08102607355', 'fishing', 'victoria', '', '', 'Ishaya', 'Father', '08102607355', 'fishing', '15 ERI Str. North Bank, Makurdi', '', '', '', '', 'yes', '', '12', '12', '2022-12-08', '2022-12-09 05:31:50', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (205, 210, '046', '015', '2022-12-08', 'Ismail', 'Munirat', 'No', 'uploads/student_images/no_image.png', '08100276788', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2018-02-04', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ismail', '081002767688', 'Businessman', '', '', '', 'Ismail', 'Father', '081002767688', 'Businessman', '', '', '', '', '', 'yes', '', '', '', '2022-12-08', '2022-12-07 23:18:28', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (206, 212, '047', '016', '2022-12-08', 'Kator', 'Joseph', 'No', 'uploads/student_images/no_image.png', '08074757253', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2017-12-18', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ulumun Joseph', '08074757253', 'Businessman', '', '', '', 'Ulumun Joseph', 'Father', '08074757253', 'Businessman', '', '', '', '', '', 'yes', '', '', '', '2022-12-08', '2022-12-07 23:22:30', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (207, 214, '172', '24', '2022-12-08', 'Julius', 'Goodiness', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2004-01-27', 'Female', '', '', '3', 0, 0, 'A-', 0, 0, '', '', '', '', '', 'father', 'JULIUS', '08102607355', 'FISHING', '', '', '', 'JULIUS', 'Father', '08102607355', 'FISHING', '', '', '', '', '', 'yes', '', '12', '31', '2022-12-08', '2022-12-09 05:32:57', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (208, 216, '048', '017', '2022-12-08', 'Ligion', 'Emmanuel', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-05-04', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ligion', '08059855131', 'Teacher', '', '', '', 'Ligion', 'Father', '08059855131', 'Teacher', '', '', '', '', '', 'yes', '', '23', '23', '2022-12-08', '2022-12-07 23:27:06', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (209, 218, '050', '019', '2022-12-08', 'Malcus', 'Miracle A.', 'No', 'uploads/student_images/no_image.png', '08012569141', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-01-12', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Malcus', '08012569141', 'Businessman', '', '', '', 'Malcus', 'Father', '08012569141', 'Businessman', '', '', '', '', '', 'yes', '', '24', '24', '2022-12-08', '2022-12-07 23:30:49', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (210, 220, '039', '020', '2022-12-08', 'Marcus', 'Sonia', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2018-09-30', 'Female', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Marcus', '08-59855131', 'Businessman', '', '', '', 'Marcus', 'Father', '08-59855131', 'Businessman', '', '', '', '', '', 'yes', '', '', '', '2022-12-08', '2022-12-09 06:56:07', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (211, 222, '173', '7', '2022-12-08', 'Kabiru', 'Yahaya', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com12', NULL, NULL, NULL, 'Christian', '', '2019-06-04', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Yahaya', '08102607355', 'teaching', 'victoria', '08102607355', 'teaching', 'Yahaya', 'Father', '08102607355', 'teaching', '15 ERI STR,NORTH BANK,MAKUDI', '', '', '', '', 'yes', '', '12', '43', '2022-12-08', '2022-12-09 05:53:39', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (212, 224, '051', '008', '2022-12-08', 'Mohammed', 'Abdulsamad', 'No', 'uploads/student_images/no_image.png', '07026697612', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-12-19', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Mohammed', '07026697612', 'Businessman', '', '', '', 'Mohammed', 'Father', '07026697612', 'Businessman', '', '', '', '', '', 'yes', '', '25', '25', '2022-12-08', '2022-12-07 23:39:06', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (213, 226, '052', '021', '2022-12-08', 'Ochewola', 'O Comfort', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.com', NULL, NULL, NULL, 'Christain', '', '2022-03-09', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ochewola', '08059855131', 'Businessman', '', '', '', 'Ochewola', 'Father', '08059855131', 'Businessman', '', '', '', '', '', 'yes', '', '26', '26', '2022-12-08', '2022-12-07 23:43:58', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (214, 228, '174', '25', '2022-12-08', 'Kalu', 'Glory', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-01-08', 'Male', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Kalu', '08102607355', 'Builder', '', '', '', 'Kalu', 'Father', '08102607355', 'Builder', '15 Eri Str. North BANK', '', '', '', '', 'yes', '', '12', '7', '2022-12-08', '2022-12-09 05:33:55', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (215, 230, '053', '022', '2022-12-08', 'Ochigbo', 'Laurel Oche', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2018-03-06', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ochigbo', '08102607355', 'Teracher', '', '', '', 'Ochigbo', 'Father', '08102607355', 'Teracher', '', '', '', '', '', 'yes', '', '27', '27', '2022-12-08', '2022-12-07 23:47:55', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (216, 232, '054', '023', '2022-12-08', 'Ochogbe', 'Kelvin', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-12-07', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ochogbe', '08102607355', 'Businessman', '', '', '', 'Ochogbe', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '28', '28', '2022-12-08', '2022-12-07 23:52:04', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (217, 234, '175', '26', '2022-12-08', 'Luka', 'Comfort', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2008-12-28', 'Female', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Luka', '08102607355', 'FARMING', '', '', '', 'Luka', 'Father', '08102607355', 'FARMING', '15 Eri Str NorthBank MAKURDI', '', '', '', '', 'yes', '', '12', '15', '2022-12-08', '2022-12-09 05:35:36', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (218, 236, '055', '024', '2022-12-08', 'Ogwah', 'Favour', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2018-07-02', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ogwah', '08059855131', 'Businessman', '', '', '', 'Ogwah', 'Father', '08059855131', 'Businessman', '', '', '', '', '', 'yes', '', '29', '29', '2022-12-08', '2022-12-07 23:56:50', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (219, 238, '056', '025', '2022-12-08', 'Okoro Odum', 'Delight', 'No', 'uploads/student_images/no_image.png', '08067648022', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2018-05-04', 'Female', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Okoro Odum', '08067648022', 'Businessman', '', '', '', 'Okoro Odum', 'Father', '08067648022', 'Businessman', '', '', '', '', '', 'yes', '', '30', '30', '2022-12-08', '2022-12-08 00:01:56', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (220, 240, '176', '27', '2022-12-08', 'Matthew', 'Markus', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Nigeria', '', '2009-01-04', 'Female', '', '', '3', 0, 0, 'O-', 0, 0, '', '', '', '', '', 'father', 'Markus', '08102607355', 'Civil servant', '', '', '', 'Markus', 'Father', '08102607355', 'Civil servant', '15 Eri Str. North Bank makurdi', '', '', '', '', 'yes', '', '13', '41', '2022-12-08', '2022-12-09 05:36:38', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (221, 242, '057', '026', '2022-12-08', 'Orinya', 'Victory', 'No', 'uploads/student_images/no_image.png', '09017365255', 'PiusOchigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2016-11-28', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Orinya Mercy', '09017365255', 'Trader', '', '', '', 'Orinya Mercy', 'Father', '09017365255', 'Trader', '', '', '', '', '', 'yes', '', '31', '31', '2022-12-08', '2022-12-08 00:07:12', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (222, 244, '058', '027', '2022-12-08', 'Oyigocho', 'Godwin', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-12-07', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Oyigocho', '08102607355', 'Businessman', '', '', '', 'Oyigocho', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '33', '33', '2022-12-08', '2022-12-08 00:11:11', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (223, 246, '059', '028', '2022-12-08', 'Utim', 'Lawrence', 'No', 'uploads/student_images/no_image.png', '07039037358', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2018-12-07', 'Male', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Utim', '07039037358', 'Businessman', '', '', '', 'Utim', 'Father', '07039037358', 'Businessman', '', '', '', '', '', 'yes', '', '34', '34', '2022-12-08', '2022-12-08 00:15:17', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (224, 248, '060', '001', '2022-12-08', 'Agbo', 'Wisdom', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.gmailcom', NULL, NULL, NULL, 'Christain', '', '2019-09-03', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Agbo', '08059855131', 'Businessman', '', '', '', 'Agbo', 'Father', '08059855131', 'Businessman', '', '', '', '', '', 'yes', '', '34', '34', '2022-12-08', '2022-12-08 00:28:50', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (225, 250, '177', '38', '2022-12-13', 'Matthew', 'Precious', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2018-03-25', 'Female', '', '', '3', 0, 0, 'AB-', 0, 0, '', '', '', '', '', 'father', 'Matthew', '08102607355', 'Civil servant', 'VICTORIA', '08102607355', 'TEACHING', 'Matthew', 'Father', '08102607355', 'Civil servant', '15 Eri NORTH BANK ,MAKURDI', '', '', '', '', 'yes', '', '12', '43', '2022-12-08', '2022-12-09 05:37:35', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (226, 252, '061', '002', '2022-12-08', 'Chukwudi', 'Victoria', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.gmailcom', NULL, NULL, NULL, 'Christain', '', '2020-12-08', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Chukwudi', '08059855131', 'Teacher', '', '', '', 'Chukwudi', 'Father', '08059855131', 'Teacher', '', '', '', '', '', 'yes', '', '34', '34', '2022-12-08', '2022-12-08 00:33:58', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (227, 254, '062', '003', '2022-12-08', 'Danjuma', 'Awase', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2017-08-07', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Danjuma', '08059855131', 'Trader', '', '', '', 'Danjuma', 'Father', '08059855131', 'Trader', '', '', '', '', '', 'yes', '', '35', '35', '2022-12-08', '2022-12-08 00:38:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (228, 256, '178', '28', '2022-12-08', 'Momoh', 'Jessica', 'No', 'uploads/student_images/no_image.png', '0810260755', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2017-11-19', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Momoh', '08102607355', 'civil servant', 'victoria', '08102607355', 'Trading', 'Momoh', 'Father', '08102607355', 'civil servant', '15 Eri Str NorthBANK', '', '', '', '', 'yes', '', '13', '23', '2022-12-08', '2022-12-09 05:38:22', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (229, 258, '063', '004', '2022-12-08', 'Friday', 'Joy', 'No', 'uploads/student_images/no_image.png', '08059855131', 'jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-05-04', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Friday', '08059855131', 'Trader', '', '', '', 'Friday', 'Father', '08059855131', 'Trader', '', '', '', '', '', 'yes', '', '36', '36', '2022-12-08', '2022-12-08 00:42:11', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (230, 260, '064', '005', '2022-12-08', 'Friday', 'Ezekiel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-07-05', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Friday', '08102607355', 'Trader', '', '', '', 'Friday', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '36', '36', '2022-12-08', '2022-12-08 00:47:15', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (231, 262, '065', '006', '2022-12-08', 'Innocent', 'Comfort', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2020-12-07', 'Female', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Innocent', '08102607355', 'Trader', '', '', '', 'Innocent', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '35', '35', '2022-12-08', '2022-12-08 00:50:06', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (232, 264, '066', '007', '2022-12-08', 'Ismail', 'Fatima', 'No', 'uploads/student_images/no_image.png', '08100276788', 'Ismialnuratu14gmail.com', NULL, NULL, NULL, 'Muslim', '', '2016-09-02', 'Female', 'Eri 3 street northbank', 'Eri 3 street northbank', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'mother', 'Ismail', '08100276788', 'Trader', '', '', '', 'Nuratu', 'Mother', '08100276788', 'Trader', '', '', '', '', '', 'yes', '', '37', '37', '2022-12-08', '2022-12-08 03:56:29', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (233, 266, '067', '008', '2022-12-08', 'Isua', 'Dennis', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2020-07-08', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Isua', '08102607355', 'Trader', '', '', '', 'Isua', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '38', '38', '2022-12-08', '2022-12-08 00:56:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (234, 268, '068', '009', '2022-12-08', 'Macus', 'Mirabel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2019-12-04', 'Female', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Macus', '08102607355', 'Teacher', '', '', '', 'Macus', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '39', '39', '2022-12-08', '2022-12-08 01:00:22', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (235, 270, '179', '9', '2022-12-08', 'Momoh', 'Jerome', 'No', 'uploads/student_images/no_image.png', '081026073', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2016-11-06', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Momoh', '08102607355', 'Civil servant', 'victoria', '08102607355', 'trading', 'Momoh', 'Father', '08102607355', 'Civil servant', '15 ERI north bank MAKURDI', '', '', '', '', 'yes', '', '21', '54', '2022-12-08', '2022-12-09 05:39:25', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (236, 272, '069', '10', '2022-12-08', 'Mofful', 'Stephanie', 'No', 'uploads/student_images/no_image.png', '080102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-05-03', 'Female', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Mofful', '080102215118', 'Trader', '', '', '', 'Mofful', 'Father', '080102215118', 'Trader', '', '', '', '', '', 'yes', '', '39', '39', '2022-12-08', '2022-12-08 01:05:17', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (237, 274, '070', '011', '2022-12-08', 'Nderenen', 'Fada', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-02-07', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Nderenen', '08102215118', 'Trader', '', '', '', 'Nderenen', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '40', '40', '2022-12-08', '2022-12-08 01:08:59', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (238, 276, '071', '012', '2022-12-08', 'Noah', 'Donald', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-06-06', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Noah', '08102215118', 'Trader', '', '', '', 'Noah', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '41', '41', '2022-12-08', '2022-12-08 01:11:51', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (239, 278, '180', '35', '2022-12-08', 'Musa', 'Farida', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2016-10-10', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Musa', '08102607355', 'Driving', 'VICTORIA', '08102607355', 'TRADING', 'Musa', 'Father', '08102607355', 'Driving', '15 Eri NorthBANK', '', '', '', '', 'yes', '', '32', '45', '2022-12-08', '2022-12-08 01:14:31', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (240, 280, '072', '013', '2022-12-08', 'Onoja', 'David', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-01-12', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Onoja', '08102215118', 'Trader', '', '', '', 'Onoja', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '42', '42', '2022-12-08', '2022-12-08 01:15:03', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (241, 282, '073', '014', '2022-12-08', 'Okojokwu', 'Solomon', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-06-27', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Okojokwu', '08102215118', 'Businessman', '', '', '', 'Okojokwu', 'Father', '08102215118', 'Businessman', '', '', '', '', '', 'yes', '', '45', '45', '2022-12-08', '2022-12-08 01:17:59', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (242, 284, '074', '015', '2022-12-08', 'Usman', 'Zinat', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2019-06-03', 'Male', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Usman', '08102215118', 'Trader', '', '', '', 'Usman', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '46', '46', '2022-12-08', '2022-12-08 01:21:30', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (243, 286, '075', '016', '2022-12-08', 'Utanger', 'Comfort', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-03-08', 'Female', '', '', '2', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Utanger', '08102607355', 'Trader', '', '', '', 'Utanger', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '48', '48', '2022-12-08', '2022-12-08 01:24:06', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (244, 288, '076', '017', '2022-12-08', 'Utim', 'Cosmas', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-05-03', 'Male', '', '', '2', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Utim', '08102215118', 'Businessman', '', '', '', 'Utim', 'Father', '08102215118', 'Businessman', '', '', '', '', '', 'yes', '', '49', '49', '2022-12-08', '2022-12-08 01:27:12', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (245, 290, '182', '39', '2022-12-08', 'Ochigbo', 'Emmanuel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com1', NULL, NULL, NULL, 'Christian', '', '2015-04-27', 'Male', '', '', '3', 0, 0, 'AB-', 0, 0, '', '', '', '', '', 'father', 'OBASIO', '08102607355', 'Trading', 'victoria', '08102607355', '', 'OBASIO', 'Father', '08102607355', 'Trading', '15 eri STR North BANK', '', '', '', '', 'yes', '', '11', '31', '2022-12-08', '2022-12-09 06:05:40', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (246, 292, '181', '37', '2022-12-08', 'Obasi', 'Chemeriem', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com1', NULL, NULL, NULL, 'Christian', '', '2015-04-27', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'OBASIO', '08102607355', 'Trading', 'victoria', '08102607355', '', 'OBASIO', 'Father', '08102607355', 'Trading', '15 eri STR North BANK', '', '', '', '', 'yes', '', '11', '31', '2022-12-08', '2022-12-08 15:08:36', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (247, 294, '077', '002', '2022-12-08', 'Aba', 'Dooshima', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2014-10-23', 'Female', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Aba', '08102215118', 'Trader', '', '', '', 'Aba', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '15', '15', '2022-12-08', '2022-12-08 04:01:38', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (248, 296, '182', '34', '2022-12-08', 'ochigbo', 'Victor', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-01-29', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ochigbo', '08102607355', 'Civil servant', '', '', '', 'Ochigbo', 'Father', '08102607355', 'Civil servant', '15 Eri ,North Bank, MAKURDI', '', '', '', '', 'yes', '', '12', '32', '2022-12-08', '2022-12-09 05:49:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (249, 298, '183', '30', '2022-12-08', 'Ohida', 'Ephraim', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-08-26', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ohida', '08102607355', 'Trading', '', '', '', 'Ohida', 'Father', '08102607355', 'Trading', '15 ERI STR ,NORTH BANK', '', '', '', '', 'yes', '', '21', '34', '2022-12-08', '2022-12-09 05:50:12', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (250, 300, '183', '31', '2022-12-08', 'Ohida', 'Ephraim', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-08-26', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ohida', '08102607355', 'Trading', '', '', '', 'Ohida', 'Father', '08102607355', 'Trading', '15 ERI STR ,NORTH BANK', '', '', '', '', 'yes', '', '21', '34', '2022-12-08', '2022-12-08 11:38:27', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (251, 302, '185', '32', '2022-12-08', 'Okafor', 'Victor', 'No', 'uploads/student_images/no_image.png', '', '', NULL, NULL, NULL, 'Nigeria', '', '2015-01-06', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Okafor', '08102607355', 'Trading', '', '', '', 'Okafor', 'Father', '08102607355', 'Trading', '15 Eri NORTH bank', '', '', '', '', 'yes', '', '12', '13', '2022-12-08', '2022-12-08 11:49:39', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (252, 304, '184', '41', '2022-12-08', 'Okafor', 'Victor', 'No', 'uploads/student_images/no_image.png', '', '', NULL, NULL, NULL, 'Nigeria', '', '2015-01-06', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Okafor', '08102607355', 'Trading', '', '', '', 'Okafor', 'Father', '08102607355', 'Trading', '15 Eri NORTH bank', '', '', '', '', 'yes', '', '12', '13', '2022-12-08', '2022-12-08 11:52:02', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (253, 306, '184', '29', '2022-12-08', 'Okafor', 'Anita', 'No', 'uploads/student_images/no_image.png', '08102607355', '', NULL, NULL, NULL, 'Cgristian', '', '2019-01-01', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Okafor', '08102607355', 'Trading', '', '', '', 'Okafor', 'Father', '08102607355', 'Trading', '15 ERI NORTHBANK', '', '', '', '', 'yes', '', '32', '14', '2022-12-08', '2022-12-09 06:15:59', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (254, 308, '078', '001', '2022-12-08', 'Ayangeaor', 'Gerald', 'No', 'uploads/student_images/no_image.png', '08116146987', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-04-05', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ayangeaor', '08116146987', 'Businessman', '', '', '', 'Ayangeaor', 'Father', '08116146987', 'Businessman', '', '', '', '', '', 'yes', '', '22', '22', '2022-12-08', '2022-12-08 12:22:15', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (255, 310, '079', '003', '2022-12-08', 'Ekpen', 'Rosemary', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2014-10-23', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ekpen', '08102215118', 'Trader', '', '', '', 'Ekpen', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '22', '22', '2022-12-08', '2022-12-08 12:26:50', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (256, 312, '080', '006', '2022-12-08', 'Jibril', 'Nasiri', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'muslim', '', '2022-12-12', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Jibril', '08102215118', 'Trader', '', '', '', 'Jibril', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '23', '23', '2022-12-08', '2022-12-08 12:30:22', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (257, 314, '186', '12', '2022-12-08', 'Olorunkiya', 'Esther', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-08-26', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Olorunkiya', '08102607355', 'Trading', '', '', '', 'Olorunkiya', 'Father', '08102607355', 'Trading', '14Eri Str. North Bank', '', '', '', '', 'yes', '', '12', '34', '2022-12-08', '2022-12-09 05:55:38', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (258, 316, '081', '005', '2022-12-08', 'Nathaniel', 'Grace', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-06-08', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Nathanniel', '08102607355', 'Trader', '', '', '', 'Nathanniel', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '24', '24', '2022-12-08', '2022-12-08 12:34:45', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (259, 318, '082', '004', '2022-12-08', 'Nekima', 'Fatima', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2022-12-04', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Nekima', '08102607355', 'Businessman', '', '', '', 'Nekima', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '24', '24', '2022-12-08', '2022-12-08 12:44:41', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (260, 320, '083', '007', '2022-12-08', 'Tila', 'Joy', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.com', NULL, NULL, NULL, 'Christain', '', '2021-09-13', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Tila', '08102215118', 'Trader', '', '', '', 'Tila', 'Father', '08102215118', 'Trader', '', '', '', '', '', 'yes', '', '25', '25', '2022-12-08', '2022-12-08 12:48:38', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (261, 322, '084', '008', '2022-12-08', 'Usman', 'Ibrahim', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2022-12-11', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Usman', '08102607355', 'Businessman', '', '', '', 'Usman', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '26', '26', '2022-12-08', '2022-12-08 12:51:42', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (262, 324, '085', '001', '2022-12-08', 'Amough', 'Ezekiel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-05-02', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Amough', '08102607355', 'Trader', '', '', '', 'Amough', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '27', '27', '2022-12-08', '2022-12-08 12:56:46', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (263, 326, '086', '002', '2022-12-08', 'Ikumokomi', 'Adasasa', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-05-03', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ikumokomi', '08102607355', 'Trader', '', '', '', 'Ikumokomi', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '28', '28', '2022-12-08', '2022-12-08 13:00:03', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (264, 328, '088', '003', '2022-12-08', 'Innocent', 'Emmanuella', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinusgmail.com ', NULL, NULL, NULL, 'Christain', '', '2022-09-06', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Innocent', '08059855131', 'Ttrader', '', '', '', 'Innocent', 'Father', '08059855131', 'Ttrader', '', '', '', '', '', 'yes', '', '29', '29', '2022-12-08', '2022-12-08 13:02:36', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (265, 330, '087', '004', '2022-12-08', 'Joepeter', 'Emmanuella', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-08-09', 'Female', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Joepeter', '08059855131', 'Businessman', '', '', '', 'Joepeter', 'Father', '08059855131', 'Businessman', '', '', '', '', '', 'yes', '', '30', '30', '2022-12-08', '2022-12-08 13:05:51', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (266, 332, '089', '005', '2022-12-08', 'Ogbo', 'Victor', 'No', 'uploads/student_images/no_image.png', '08059855131', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-11', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ogbo', '08059855131', 'Teacher', '', '', '', 'Ogbo', 'Father', '08059855131', 'Teacher', '', '', '', '', '', 'yes', '', '31', '31', '2022-12-08', '2022-12-08 13:09:08', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (267, 334, '090', '006', '2022-12-08', 'Okoro', 'Divine', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Male', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Okoro', '08102607355', 'driver', '', '', '', 'Okoro', 'Father', '08102607355', 'driver', '', '', '', '', '', 'yes', '', '32', '32', '2022-12-08', '2022-12-08 13:19:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (268, 336, '091', '007', '2022-12-08', 'Teraki', 'Rita', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Teraki', '08102607355', 'Teacher', '', '', '', 'Teraki', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '34', '34', '2022-12-08', '2022-12-08 13:21:58', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (269, 338, '092', '008', '2022-12-08', 'Terlumun', 'Kelvin', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-13', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Terlumun', '08102607355', 'Teacher', '', '', '', 'Terlumun', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '36', '36', '2022-12-08', '2022-12-08 13:25:25', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (270, 340, '093', '009', '2022-12-08', 'Tersoo', 'Mathias', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Tersoo', '08102607355', '', '', '', '', 'Tersoo', 'Father', '08102607355', '', '', '', '', '', '', 'yes', '', '37', '37', '2022-12-08', '2022-12-08 13:28:16', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (271, 342, '187', '11', '2022-12-08', 'Onoja', 'EVANS', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-02-27', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'ONOJA', '08102607355', 'TEACHING', '', '', '', 'ONOJA', 'Father', '08102607355', 'TEACHING', '15 ERI ,northbank', '', '', '', '', 'yes', '', '12', '32', '2022-12-08', '2022-12-09 05:43:55', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (272, 344, '094', '001', '2022-12-08', 'Abila', 'Emmanuel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Abila', '08102607355', 'Trader', '', '', '', 'Abila', 'Father', '08102607355', 'Trader', '', '', '', '', '', 'yes', '', '39', '39', '2022-12-08', '2022-12-08 13:42:32', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (273, 346, '095', '002', '2022-12-08', 'Agbo', 'Praise', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Male', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Agbo', '08102607355', 'Businessman', '', '', '', 'Agbo', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '40', '40', '2022-12-08', '2022-12-08 13:43:07', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (274, 348, '096', '003', '2022-12-08', 'Agyoza', 'Praise Gabriel', 'No', 'uploads/student_images/no_image.png', '09160905492', 'agyozajuniorgmail.com', NULL, NULL, NULL, 'Christain', '', '2008-05-20', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Agyoza', '09160905492', 'Businessman', '', '', '', 'Agyoza', 'Father', '09160905492', 'Businessman', '', '', '', '', '', 'yes', '', '', '', '2022-12-08', '2022-12-08 13:46:33', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (275, 350, '188', '13', '2022-12-08', 'Onoja', 'Gabriel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-01-29', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Onoja', '08102607355', 'TEACHING', '', '', '', 'Onoja', 'Father', '08102607355', 'TEACHING', '15 eri Str. ,NORTH BANK', '', '', '', '', 'yes', '', '52', '12', '2022-12-08', '2022-12-09 05:45:19', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (276, 352, '097', '005', '2022-12-08', 'Apezan', 'Magdalene', 'No', 'uploads/student_images/no_image.png', '07030276070', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2011-05-05', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Apezan', '07030276070', 'Trader', '', '', '', 'Apezan', 'Father', '07030276070', 'Trader', '', '', '', '', '', 'yes', '', '41', '41', '2022-12-08', '2022-12-08 13:51:38', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (277, 354, '098', '004', '2022-12-08', 'Chiever', 'Benedita', 'No', 'uploads/student_images/no_image.png', '0706337151508', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2012-05-14', 'Female', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Chiever', '0706337151508', 'Soldier', '', '', '', 'Chiever', 'Father', '0706337151508', 'Soldier', 'Back of Army chidren school', '', '', '', '', 'yes', '', '43', '43', '2022-12-08', '2022-12-08 13:57:13', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (278, 356, '099', '006', '2022-12-08', 'Joseph', 'Theresa', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-05', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Joseph', '08102607355', 'Businessman', '', '', '', 'Joseph', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '44', '44', '2022-12-08', '2022-12-08 14:00:51', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (279, 358, '189', '14', '2022-12-08', 'Onu', 'Angel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2019-04-29', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'onu', '8102607355', '', '', '', '', 'onu', 'Father', '8102607355', '', '15 Eri North BANK', '', '', '', '', 'yes', '', '12', '43', '2022-12-08', '2022-12-08 14:02:20', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (280, 360, '100', '007', '2022-12-08', 'Ogbu', 'Blessing', 'No', 'uploads/student_images/no_image.png', '0903837800', 'Piusochigbogmail.com', NULL, NULL, NULL, 'christain', '', '2010-01-10', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ogbu', '0903837800', 'Trader', '', '', '', 'Ogbu', 'Father', '0903837800', 'Trader', 'Ventinary  Layout Northbank ', '', '', '', '', 'yes', '', '45', '45', '2022-12-08', '2022-12-08 14:05:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (281, 362, '101', '008', '2022-12-08', 'Ogwah', 'Gift', 'No', 'uploads/student_images/no_image.png', '08037559932', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2019-08-28', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ogwah', '08037559932', 'Muscian', '', '', '', 'Ogwah', 'Father', '08037559932', 'Muscian', 'Back of E cwa primary school', '', '', '', '', 'yes', '', '46', '46', '2022-12-08', '2022-12-08 14:09:19', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (282, 364, '102', '009', '2022-12-08', 'Okojokwu', 'Angel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Female', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Okojokwu', '08102607355', 'teacher', '', '', '', 'Okojokwu', 'Father', '08102607355', 'teacher', '', '', '', '', '', 'yes', '', '47', '47', '2022-12-08', '2022-12-08 14:12:16', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (283, 366, '103', '010', '2022-12-08', 'Ugwu', 'Samson', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118.gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-11', 'Male', '', '', '2', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ugwu', '08102215118', 'Teacher', '', '', '', 'Ugwu', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '48', '48', '2022-12-08', '2022-12-08 14:14:33', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (284, 368, '190', '10', '2022-12-08', 'Onyebuchi', 'Solomon', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajepgmail.com', NULL, NULL, NULL, 'Christian', '', '2015-12-29', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Onyebuchi', '08102607355', 'trading', '', '', '', 'Onyebuchi', 'Father', '08102607355', 'trading', '15 ERI ,Str North Bank', '', '', '', '', 'yes', '', '32', '23', '2022-12-08', '2022-12-09 05:48:14', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (285, 370, '104', '011', '2022-12-08', 'Utange', 'Nater', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-04', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Utange', '08102215118', '', '', '', '', 'Utange', 'Father', '08102215118', '', '', '', '', '', '', 'yes', '', '50', '50', '2022-12-08', '2022-12-08 14:18:11', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (286, 372, '105', '012', '2022-12-08', 'Yoosu', 'Emmanuel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'christain', '', '2022-06-21', 'Male', '', '', '2', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Yoosu', '08102607355', 'Teacher', '', '', '', 'Yoosu', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '51', '51', '2022-12-08', '2022-12-08 14:20:25', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (287, 374, '106', '001', '2022-12-08', 'Emberga', 'Terhemen', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-05-03', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Emberga', '08102607355', 'Businessman', '', '', '', 'Emberga', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '52', '52', '2022-12-08', '2022-12-08 14:26:58', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (288, 376, '191', '15', '2022-12-08', 'Samson', 'Godday', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2018-10-05', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Samsom', '08102607355', 'FISHING', '', '', '', 'Samsom', 'Father', '08102607355', 'FISHING', '', '', '', '', '', 'yes', '', '12', '34', '2022-12-08', '2022-12-08 14:28:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (289, 378, '191', '16', '2022-12-08', 'Samson', 'Godday', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2018-10-05', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Samsom', '08102607355', 'FISHING', '', '', '', 'Samsom', 'Father', '08102607355', 'FISHING', '', '', '', '', '', 'yes', '', '12', '34', '2022-12-08', '2022-12-09 05:51:07', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (290, 380, '107', '002', '2022-12-08', 'Joseph', 'Mary', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2021-08-31', 'Female', '', '', '2', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Joseph', '08102607355', 'trader', '', '', '', 'Joseph', 'Father', '08102607355', 'trader', '', '', '', '', '', 'yes', '', '56', '56', '2022-12-08', '2022-12-08 14:29:51', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (291, 382, '108', '003', '2022-12-08', 'Marcus', 'Benjamin', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-11-28', 'Male', '', '', '2', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Marcus', '08102215118', 'Teacher', '', '', '', 'Marcus', 'Father', '08102215118', 'Teacher', '', '', '', '', '', 'yes', '', '57', '57', '2022-12-08', '2022-12-08 14:32:23', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (292, 384, '109', '004', '2022-12-08', 'Okojokwu', 'Kingsley', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2021-07-06', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Okojokwu', '08102215118', 'Businessman', '', '', '', 'Okojokwu', 'Father', '08102215118', 'Businessman', '', '', '', '', '', 'yes', '', '53', '53', '2022-12-08', '2022-12-08 14:37:33', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (293, 386, '110', '005', '2022-12-08', 'Teraki', 'Raphael', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Male', '', '', '2', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Teraki', '08102215118', 'Businessman', '', '', '', 'Teraki', 'Father', '08102215118', 'Businessman', '', '', '', '', '', 'yes', '', '54', '54', '2022-12-08', '2022-12-08 14:42:01', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (294, 388, '192', '17', '2022-12-08', 'Samuel', 'Naomi', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Chtistian', '', '2009-10-27', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Samuel', '08102607355', 'Fishing', '', '', '', 'Samuel', 'Father', '08102607355', 'Fishing', '14 Eri Str.,NORTH bank', '', '', '', '', 'yes', '', '43', '12', '2022-12-08', '2022-12-09 05:52:06', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (295, 390, '197', '001', '2022-12-08', 'Ebioth', 'Victor T.', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-02-08', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Ebioth', '08102607355', 'Businessman', '', '', '', 'Ebioth', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '55', '55', '2022-12-08', '2022-12-08 14:46:25', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (296, 392, '193', '45', '2022-12-08', 'Unogwu', 'Destiny', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christan', '', '2020-02-10', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'unogwu', '08102607355', 'Driving', '', '', '', 'unogwu', 'Father', '08102607355', 'Driving', '12 eri str.north bank', '', '', '', '', 'yes', '', '61', '12UNOG', '2022-12-08', '2022-12-08 14:56:54', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (297, 394, '194', '42', '2022-12-09', 'Usman', 'Mushammed', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2017-03-06', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'USMAN', '08102607355', 'Civil servant', '', '', '', 'USMAN', 'Father', '08102607355', 'Civil servant', '15 ERI ,North BANK', '', '', '', '', 'yes', '', '23', '12', '2022-12-09', '2022-12-09 00:50:32', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (298, 396, '195', '43', '2022-12-09', 'Utange', 'Beatrice', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2021-06-28', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Utange', '08102607355', 'FARMING', '', '', '', 'Utange', 'Father', '08102607355', 'FARMING', '15 Eri NorthBank', '', '', '', '', 'yes', '', '23', '50', '2022-12-09', '2022-12-09 01:01:06', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (299, 398, '196', '44', '2022-12-09', 'Zakariya', 'Success', 'No', 'uploads/student_images/no_image.png', '08102607355', 'piusogajegmail.com', NULL, NULL, NULL, 'Christian', '', '2018-12-03', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Zakariya', '08102607355', 'Farming', '', '', '', 'Zakariya', 'Father', '08102607355', 'Farming', '15 Eri Str. North Bank', '', '', '', '', 'yes', '', '34', '21', '2022-12-09', '2022-12-09 01:10:37', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (300, 400, '198', '002', '2022-12-09', 'Ebioth', 'Ruth', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochibgogmailgmail.com', NULL, NULL, NULL, 'Christain', '', '2008-09-30', 'Female', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ebioth Anthony', '08102607355', 'Businessman', '', '', '', 'Ebioth Anthony', 'Father', '08102607355', 'Businessman', '', '', '', '', '', 'yes', '', '07', '25', '2022-12-09', '2022-12-09 05:03:10', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (301, 402, '199', '003', '2022-12-09', 'Emberga', 'Wilfred .T', 'No', 'uploads/student_images/no_image.png', '081235570859', '', NULL, NULL, NULL, 'Christain', '', '2005-02-02', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'mother', 'mrs Emberga Terbur', '081235570859', 'Businessman', 'Emberga Terbur', '', '', 'Emberga Terbur', 'Mother', '081235570859', '', 'Serve Guma local government', '', '', '', '', 'yes', '', '', '', '2022-12-09', '2022-12-09 05:11:42', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (302, 404, '200', '004', '2022-12-09', 'Mohammed', 'Mustapha', 'No', 'uploads/student_images/no_image.png', '07037863638', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2006-06-03', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Mr Okabichi Barthlomew', '0703763638', 'Businessman', '', '', '', 'Mr Okabichi Barthlomew', 'Father', '0703763638', 'Businessman', 'No 3 Mkar street northbank ', '', '', '', '', 'yes', '', '7', '25', '2022-12-09', '2022-12-09 05:16:43', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (303, 406, '201', '005', '2022-12-09', 'Ochigbo', 'Benedit', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2007-07-05', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Mr Pius Ochigbo', '08102607355', 'Teacher', 'Mrs Victoria Ochigbo', '08139432042', 'Teacher', 'Mr Pius Ochigbo', 'Father', '08102607355', 'Teacher', 'No15 Eri Strreet N/B ', '', '', '', '', 'yes', '', '7', '27', '2022-12-09', '2022-12-09 05:22:54', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (304, 408, '202', '006', '2022-12-09', 'Ochigbo', 'Benedicta', 'No', 'uploads/student_images/no_image.png', '08139432042', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2007-07-05', 'Female', '', '', '3', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'Mr Ochigbo Pius', '08102607355', 'Teacher', '', '', '', 'Mr Ochigbo Pius', 'Father', '08102607355', 'Teacher', 'No 15 Eri street nothbank', '', '', '', '', 'yes', '', '6', '26', '2022-12-09', '2022-12-09 05:27:10', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (305, 410, '203', '007', '2022-12-09', 'Shuaibu', 'Hafsat', 'No', 'uploads/student_images/no_image.png', '08030596657', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Muslim', '', '2006-05-13', 'Female', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Shuaibu', '08030596657', 'Businessman', '', '', '', 'Shuaibu', 'Father', '08030596657', 'Businessman', 'N0 22 Ekan street N/bank', '', '', '', '', 'yes', '', '6', '27', '2022-12-09', '2022-12-09 05:33:24', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (306, 412, '204', '008', '2022-12-09', 'Abdulkarim', 'Aishat', 'No', 'uploads/student_images/no_image.png', '08134190661', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Muslim', '', '2009-02-07', 'Female', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Nafisat Salihu', '08134190661', 'Businessman', '', '', '', 'Nafisat Salihu', 'Father', '08134190661', 'Businessman', 'No 14 Eri street N/bank ', '', '', '', '', 'yes', '', '6', '28', '2022-12-09', '2022-12-09 05:38:30', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (307, 414, '118', '043', '2022-12-09', 'Anzoko', 'Daniel', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-05', 'Male', '', '', '3', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'father', 'Anzoko', '08102607355', 'Teacher', '', '', '', 'Anzoko', 'Father', '08102607355', 'Teacher', ' 14 dayspring satreet N/Bank', '', '', '', '', 'yes', '', '13', '15', '2022-12-09', '2022-12-09 06:31:06', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (308, 416, '127', '027', '2022-12-09', 'Gbenida', 'Doose', 'No', 'uploads/student_images/no_image.png', '08102215118', 'Jephlinus118gmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-12', 'Female', '', '', '3', 0, 0, 'B+', 0, 0, '', '', '', '', '', 'father', 'Gbenida', '08102215118', 'Farmer', '', '', '', 'Gbenida', 'Father', '08102215118', 'Farmer', '', '', '', '', '', 'yes', '', '11', '11', '2022-12-09', '2022-12-09 06:34:19', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (309, 418, '130', '011', '2022-12-09', 'Ibem', 'Joshua ', 'No', 'uploads/student_images/no_image.png', '08102607355', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2022-12-13', 'Male', '', '', '3', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Ibem', '08102607355', 'Teacher', '', '', '', 'Ibem', 'Father', '08102607355', 'Teacher', '', '', '', '', '', 'yes', '', '20', '20', '2022-12-09', '2022-12-09 06:41:03', '0000-00-00 00:00:00', '0000-00-00', '');
INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES (310, 420, '0048', '007', '2022-12-09', 'Ligion', 'Emmanuel', 'No', 'uploads/student_images/no_image.png', '07063294100', 'Piusochigbogmail.com', NULL, NULL, NULL, 'Christain', '', '2017-03-17', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Mr Ligion ', '07063294100', 'Businessman', '', '', '', 'Mr Ligion', 'Father', '07063294100', 'Businessman', '', '', '', '', '', 'yes', '', '4', '4', '2022-12-09', '2022-12-09 07:13:03', '0000-00-00 00:00:00', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: subjects
#

DROP TABLE IF EXISTS `subjects`;

CREATE TABLE `subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Mathematics', '', 'Theory', 'no', '2022-11-24 04:47:02', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'English Language', '', 'Theory', 'no', '2022-11-24 04:47:16', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Agricultural Science', '', 'Theory', 'no', '2022-11-24 04:47:58', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Home Economics', '', 'Theory', 'no', '2022-11-24 04:48:18', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Basic Science', '', 'Theory', 'no', '2022-11-24 04:48:52', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Physical and Health Education', '', 'Theory', 'no', '2022-11-24 04:49:10', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'ICT', '', 'Theory', 'no', '2022-11-24 04:49:21', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Basic Technology', '', 'Theory', 'no', '2022-11-24 04:49:34', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Social Studies', '', 'Theory', 'no', '2022-11-24 04:49:48', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'CRK', '', 'Theory', 'no', '2022-11-24 04:49:58', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Verbal Reasoning', '', 'Theory', 'no', '2022-11-24 04:50:24', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Quantitative Reasoning', '', 'Theory', 'no', '2022-11-24 04:50:40', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'RNV', '', 'Theory', 'no', '2022-11-24 04:51:00', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'History', '', 'Theory', 'no', '2022-11-24 04:51:05', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Cultural and Creative Arts', '', 'Theory', 'no', '2022-11-24 04:51:19', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Business Studies', '', 'Theory', 'no', '2022-11-24 04:51:33', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Physics', '', 'Theory', 'no', '2022-11-24 04:51:44', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Chemistry', '', 'Theory', 'no', '2022-11-24 04:51:49', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Biology', '', 'Theory', 'no', '2022-11-24 04:52:03', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Fishery', '', 'Theory', 'no', '2022-11-24 04:52:07', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Marketing', '', 'Theory', 'no', '2022-11-24 04:52:13', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Civic Education', '', 'Theory', 'no', '2022-11-24 04:52:23', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Data Processing', '', 'Theory', 'no', '2022-11-24 04:52:41', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Further Mathematics', '', 'Theory', 'no', '2022-11-24 04:52:59', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Government', '', 'Theory', 'no', '2022-11-24 04:53:16', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Economics', '', 'Theory', 'no', '2022-11-24 04:53:28', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Literature', '', 'Theory', 'no', '2022-11-24 04:53:37', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'CRS', '', 'Theory', 'no', '2022-11-24 04:53:45', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Geography', '', 'Theory', 'no', '2022-11-24 04:53:58', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Electronics/Electricity', '', 'Theory', 'no', '2022-11-24 04:54:09', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Commerce', '', 'Theory', 'no', '2022-11-24 04:54:21', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Health Habit', '', 'Theory', 'no', '2022-11-24 04:55:01', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Fine Art', '', 'Theory', 'no', '2022-11-24 04:55:17', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Hand Writing', '', 'Theory', 'no', '2022-11-24 04:55:24', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Social Habit', '', 'Theory', 'no', '2022-11-24 04:55:31', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Rhymes', '', 'Theory', 'no', '2022-11-24 04:55:45', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Phonics', '', 'Theory', 'no', '2022-11-24 04:55:51', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Verbal Aptitude', '', 'Theory', 'no', '2022-11-24 04:55:59', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Quantitative Aptitude', '', 'Theory', 'no', '2022-11-24 04:56:24', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Reading Readiness', '111', 'Theory', 'no', '2022-12-09 22:39:53', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Number Readiness', '112', 'Theory', 'no', '2022-12-09 22:40:23', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Creative Arts', '113', 'Theory', 'no', '2022-12-09 22:42:40', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Rhyme', '114', 'Theory', 'no', '2022-12-09 22:42:55', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Civic Educatiom', '115', 'Theory', 'no', '2022-12-09 22:43:30', '0000-00-00 00:00:00');
INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Basic Science and Tech', '116', 'Theory', 'no', '2022-12-09 22:44:32', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: teacher_subjects
#

DROP TABLE IF EXISTS `teacher_subjects`;

CREATE TABLE `teacher_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `class_section_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `teacher_id` int(11) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  KEY `session_id` (`session_id`),
  KEY `subject_id` (`subject_id`),
  KEY `teacher_id` (`teacher_id`)
) ENGINE=InnoDB AUTO_INCREMENT=164 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 16, 1, 1, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 16, 1, 1, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 16, 1, 34, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 16, 1, 6, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 16, 1, 35, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 16, 1, 36, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 16, 1, 37, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, 16, 1, 11, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, 16, 1, 38, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, 16, 1, 39, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (11, 16, 1, 40, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (12, 16, 1, 41, 2, NULL, 'no', '2022-11-24 05:09:34', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (13, 16, 2, 2, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (14, 16, 2, 1, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (15, 16, 2, 34, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (16, 16, 2, 6, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (17, 16, 2, 35, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (18, 16, 2, 36, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (19, 16, 2, 37, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (20, 16, 2, 11, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (21, 16, 2, 38, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (22, 16, 2, 39, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (23, 16, 2, 40, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (24, 16, 2, 41, 2, NULL, 'no', '2022-11-24 06:32:51', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (25, 16, 3, 1, 2, NULL, 'no', '2022-11-24 06:35:03', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (26, 16, 3, 2, 2, NULL, 'no', '2022-11-24 06:35:03', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (27, 16, 3, 34, 2, NULL, 'no', '2022-11-24 06:35:03', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (28, 16, 3, 6, 2, NULL, 'no', '2022-11-24 06:35:03', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (29, 16, 3, 35, 2, NULL, 'no', '2022-11-24 06:35:03', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (30, 16, 3, 36, 2, NULL, 'no', '2022-11-24 06:35:04', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (31, 16, 3, 37, 2, NULL, 'no', '2022-11-24 06:35:04', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (32, 16, 3, 11, 2, NULL, 'no', '2022-11-24 06:35:04', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (33, 16, 3, 38, 2, NULL, 'no', '2022-11-24 06:35:04', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (34, 16, 3, 39, 2, NULL, 'no', '2022-11-24 06:35:04', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (35, 16, 3, 40, 2, NULL, 'no', '2022-11-24 06:35:04', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (36, 16, 3, 41, 2, NULL, 'no', '2022-11-24 06:35:04', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (37, 16, 4, 1, 2, NULL, 'no', '2022-11-24 06:37:29', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (38, 16, 4, 2, 2, NULL, 'no', '2022-11-24 06:37:29', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (39, 16, 4, 4, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (40, 16, 4, 5, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (42, 16, 4, 6, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (43, 16, 4, 7, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (44, 16, 4, 8, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (45, 16, 4, 9, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (46, 16, 4, 10, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (47, 16, 4, 11, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (48, 16, 4, 12, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (49, 16, 4, 13, 2, NULL, 'no', '2022-11-24 06:37:30', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (50, 16, 5, 1, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (51, 16, 5, 2, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (52, 16, 5, 4, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (53, 16, 5, 5, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (54, 16, 5, 6, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (55, 16, 5, 7, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (56, 16, 5, 8, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (57, 16, 5, 9, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (58, 16, 5, 10, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (59, 16, 5, 11, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (60, 16, 5, 12, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (61, 16, 5, 13, 2, NULL, 'no', '2022-11-24 06:50:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (62, 16, 6, 1, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (63, 16, 6, 2, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (64, 16, 6, 4, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (65, 16, 6, 5, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (66, 16, 6, 6, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (67, 16, 6, 7, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (68, 16, 6, 8, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (69, 16, 6, 9, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (70, 16, 6, 10, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (71, 16, 6, 11, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (72, 16, 6, 12, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (73, 16, 6, 13, 2, NULL, 'no', '2022-11-24 06:51:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (74, 16, 7, 1, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (75, 16, 7, 2, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (76, 16, 7, 4, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (77, 16, 7, 5, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (78, 16, 7, 6, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (79, 16, 7, 7, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (80, 16, 7, 8, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (81, 16, 7, 9, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (82, 16, 7, 10, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (83, 16, 7, 11, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (84, 16, 7, 12, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (85, 16, 7, 13, 2, NULL, 'no', '2022-11-24 06:54:05', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (86, 16, 8, 1, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (87, 16, 8, 2, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (88, 16, 8, 4, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (89, 16, 8, 5, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (90, 16, 8, 6, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (91, 16, 8, 12, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (92, 16, 8, 8, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (93, 16, 8, 9, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (94, 16, 8, 10, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (95, 16, 8, 11, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (96, 16, 8, 12, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (97, 16, 8, 13, 2, NULL, 'no', '2022-11-24 06:56:38', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (98, 16, 9, 1, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (99, 16, 9, 2, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (100, 16, 9, 4, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (101, 16, 9, 5, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (102, 16, 9, 6, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (103, 16, 9, 7, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (104, 16, 9, 8, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (105, 16, 9, 9, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (106, 16, 9, 10, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (107, 16, 9, 11, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (108, 16, 9, 12, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (109, 16, 9, 13, 0, NULL, 'no', '2022-11-24 07:01:53', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (110, 16, 10, 1, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (111, 16, 10, 2, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (112, 16, 10, 6, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (113, 16, 10, 8, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (114, 16, 10, 7, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (115, 16, 10, 9, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (116, 16, 10, 5, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (117, 16, 10, 4, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (118, 16, 10, 14, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (119, 16, 10, 15, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (120, 16, 10, 16, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (121, 16, 10, 11, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (122, 16, 10, 17, 2, NULL, 'no', '2022-11-24 07:07:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (123, 16, 11, 1, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (124, 16, 11, 2, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (125, 16, 11, 6, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (126, 16, 11, 8, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (127, 16, 11, 7, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (128, 16, 11, 9, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (129, 16, 11, 5, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (130, 16, 11, 4, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (131, 16, 11, 14, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (132, 16, 11, 15, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (133, 16, 11, 16, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (134, 16, 11, 11, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (135, 16, 11, 17, 2, NULL, 'no', '2022-11-24 07:13:31', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (136, 16, 12, 1, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (137, 16, 12, 2, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (138, 16, 12, 6, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (139, 16, 12, 8, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (140, 16, 12, 7, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (141, 16, 12, 9, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (142, 16, 12, 5, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (143, 16, 12, 4, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (144, 16, 12, 14, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (145, 16, 12, 15, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (146, 16, 12, 16, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (147, 16, 12, 11, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (148, 16, 12, 17, 2, NULL, 'no', '2022-11-24 07:12:46', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (149, 16, 13, 1, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (150, 16, 13, 2, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (151, 16, 13, 18, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (152, 16, 13, 19, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (153, 16, 13, 20, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (154, 16, 13, 20, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (155, 16, 13, 21, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (156, 16, 13, 22, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (157, 16, 13, 23, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (158, 16, 13, 24, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (159, 16, 13, 25, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (160, 16, 13, 26, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (161, 16, 13, 27, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (162, 16, 13, 29, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');
INSERT INTO `teacher_subjects` (`id`, `session_id`, `class_section_id`, `subject_id`, `teacher_id`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (163, 16, 13, 28, 2, NULL, 'no', '2022-11-24 07:23:35', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: timetables
#

DROP TABLE IF EXISTS `timetables`;

CREATE TABLE `timetables` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_subject_id` int(20) DEFAULT NULL,
  `day_name` varchar(50) DEFAULT NULL,
  `start_time` varchar(50) DEFAULT NULL,
  `end_time` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: transport_route
#

DROP TABLE IF EXISTS `transport_route`;

CREATE TABLE `transport_route` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `route_title` varchar(100) DEFAULT NULL,
  `no_of_vehicle` int(11) DEFAULT NULL,
  `fare` float(10,2) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: userlog
#

DROP TABLE IF EXISTS `userlog`;

CREATE TABLE `userlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(100) DEFAULT NULL,
  `role` varchar(100) DEFAULT NULL,
  `ipaddress` varchar(100) DEFAULT NULL,
  `user_agent` varchar(500) DEFAULT NULL,
  `login_datetime` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (1, 'stivino1224@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 92.0, Windows 10', '2021-09-01 11:55:06');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (2, 'stivino1224@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 92.0, Windows 10', '2021-09-01 11:58:21');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (3, 'stivino1224@gmail.com', 'Super Admin', '127.0.0.1', 'Firefox 92.0, Windows 10', '2021-09-01 11:59:23');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (4, 'stivino1224@gmail.com', 'Super Admin', '105.112.182.103', 'Firefox 106.0, Mac OS X', '2022-11-17 10:58:17');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (5, 'stivino1224@gmail.com', 'Super Admin', '105.112.190.198', 'Firefox 106.0, Windows 10', '2022-11-18 06:38:24');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (6, 'destinymkd@gmail.com', 'Super Admin', '105.112.190.198', 'Firefox 106.0, Windows 10', '2022-11-18 06:55:19');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (7, 'destinymkd@gmail.com', 'Super Admin', '105.112.190.198', 'Firefox 106.0, Windows 10', '2022-11-18 07:03:11');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (8, 'destinymkd@gmail.com', 'Super Admin', '105.112.190.198', 'Firefox 106.0, Windows 10', '2022-11-18 07:06:38');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (9, 'destinymkd@gmail.com', 'Super Admin', '105.112.190.198', 'Firefox 106.0, Windows 10', '2022-11-18 07:09:05');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (10, 'destinymkd@gmail.com', 'Super Admin', '197.210.54.198', 'Chrome 107.0.0.0, Android', '2022-11-19 07:57:28');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (11, 'destinymkd@gmail.com', 'Super Admin', '197.210.54.208', 'Chrome 102.0.5005.63, Windows 7', '2022-11-21 05:15:39');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (12, 'destinymkd@gmail.com', 'Super Admin', '141.0.12.118', 'Opera 72.2.3767.68393, Android', '2022-11-22 23:44:28');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (13, 'destinymkd@gmail.com', 'Super Admin', '105.112.150.160', 'Firefox 106.0, Windows 10', '2022-11-24 04:42:23');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (14, 'destinymkd@gmail.com', 'Super Admin', '105.112.150.160', 'Firefox 106.0, Windows 10', '2022-11-24 04:46:39');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (15, 'destinymkd@gmail.com', 'Super Admin', '197.210.85.113', 'Chrome 107.0.0.0, Windows 10', '2022-11-25 03:30:32');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (16, 'destinymkd@gmail.com', 'Super Admin', '197.210.79.40', 'Chrome 107.0.0.0, Windows 7', '2022-12-06 15:22:52');
INSERT INTO `userlog` (`id`, `user`, `role`, `ipaddress`, `user_agent`, `login_datetime`) VALUES (17, 'destinymkd@gmail.com', 'Super Admin', '105.113.16.31', 'Firefox 107.0, Windows 10', '2022-12-11 08:28:45');


#
# TABLE STRUCTURE FOR: users
#

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `childs` text NOT NULL,
  `role` varchar(30) NOT NULL,
  `verification_code` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=421 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (1, 101, 'std101', 'wed3tf', '', 'student', '', 'yes', '2022-12-02 05:59:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (2, 0, 'parent101', 'j6jnxq', '101', 'parent', '', 'yes', '2022-12-02 05:59:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (3, 102, 'std102', 'au69om', '', 'student', '', 'yes', '2022-12-02 06:03:22', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (4, 0, 'parent102', 'j9tmss', '102', 'parent', '', 'yes', '2022-12-02 06:03:22', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (5, 103, 'std103', 'kdfuvo', '', 'student', '', 'yes', '2022-12-02 06:08:18', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (6, 0, 'parent103', '5u5cni', '103', 'parent', '', 'yes', '2022-12-02 06:08:18', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (7, 104, 'std104', '3po1zn', '', 'student', '', 'yes', '2022-12-02 06:12:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (8, 0, 'parent104', 'fv0lxh', '104', 'parent', '', 'yes', '2022-12-02 06:12:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (9, 105, 'std105', 'f21y7n', '', 'student', '', 'yes', '2022-12-02 06:16:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (10, 0, 'parent105', 'ohn74x', '105', 'parent', '', 'yes', '2022-12-02 06:16:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (11, 106, 'std106', 'mwrjgu', '', 'student', '', 'yes', '2022-12-02 06:20:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (12, 0, 'parent106', '1l6oqv', '106', 'parent', '', 'yes', '2022-12-02 06:20:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (13, 107, 'std107', 'n7gc1l', '', 'student', '', 'yes', '2022-12-02 06:23:07', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (14, 0, 'parent107', 'ujx8q1', '107', 'parent', '', 'yes', '2022-12-02 06:23:07', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (15, 108, 'std108', 'y1pcb6', '', 'student', '', 'yes', '2022-12-03 04:18:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (16, 0, 'parent108', 'rx7zfk', '108', 'parent', '', 'yes', '2022-12-03 04:18:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (17, 109, 'std109', '66usik', '', 'student', '', 'yes', '2022-12-05 02:31:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (18, 0, 'parent109', 'rrw8nd', '109', 'parent', '', 'yes', '2022-12-05 02:31:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (19, 110, 'std110', '0bnry1', '', 'student', '', 'yes', '2022-12-05 02:35:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (20, 0, 'parent110', 'ysyjnj', '110', 'parent', '', 'yes', '2022-12-05 02:35:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (21, 111, 'std111', 'jx6ndd', '', 'student', '', 'yes', '2022-12-05 02:39:09', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (22, 0, 'parent111', 'e5daf3', '111', 'parent', '', 'yes', '2022-12-05 02:39:09', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (23, 112, 'std112', 'innsll', '', 'student', '', 'yes', '2022-12-05 02:45:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (24, 0, 'parent112', 'tenppt', '112', 'parent', '', 'yes', '2022-12-05 02:45:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (25, 113, 'std113', '6607w2', '', 'student', '', 'yes', '2022-12-05 02:50:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (26, 0, 'parent113', 'o5xc29', '113', 'parent', '', 'yes', '2022-12-05 02:50:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (27, 114, 'std114', '80ybg3', '', 'student', '', 'yes', '2022-12-05 02:55:09', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (28, 0, 'parent114', 'nbh1al', '114', 'parent', '', 'yes', '2022-12-05 02:55:09', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (29, 115, 'std115', 'y4esdf', '', 'student', '', 'yes', '2022-12-05 02:58:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (30, 0, 'parent115', '8n0ke4', '115', 'parent', '', 'yes', '2022-12-05 02:58:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (31, 116, 'std116', 'lxzotf', '', 'student', '', 'yes', '2022-12-05 03:01:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (32, 0, 'parent116', 'ru5yt6', '116', 'parent', '', 'yes', '2022-12-05 03:01:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (33, 117, 'std117', 'rxv2fe', '', 'student', '', 'yes', '2022-12-05 03:05:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (34, 0, 'parent117', '6khwdf', '117', 'parent', '', 'yes', '2022-12-05 03:05:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (35, 118, 'std118', '20spvj', '', 'student', '', 'yes', '2022-12-05 03:11:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (36, 0, 'parent118', 'ukh77y', '118', 'parent', '', 'yes', '2022-12-05 03:11:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (37, 119, 'std119', 'mnwkpy', '', 'student', '', 'yes', '2022-12-07 10:48:43', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (38, 0, 'parent119', '1hi69l', '119', 'parent', '', 'yes', '2022-12-07 10:48:43', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (39, 120, 'std120', 'dt8zzj', '', 'student', '', 'yes', '2022-12-07 10:52:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (40, 0, 'parent120', 'aqjgz0', '120', 'parent', '', 'yes', '2022-12-07 10:52:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (41, 121, 'std121', 'gjxq8f', '', 'student', '', 'yes', '2022-12-07 11:00:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (42, 0, 'parent121', '5o4mt5', '121', 'parent', '', 'yes', '2022-12-07 11:00:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (43, 122, 'std122', 'i4aqre', '', 'student', '', 'yes', '2022-12-07 11:03:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (44, 0, 'parent122', 'nax8t1', '122', 'parent', '', 'yes', '2022-12-07 11:03:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (45, 123, 'std123', '9wzy44', '', 'student', '', 'yes', '2022-12-07 11:10:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (46, 0, 'parent123', 'truuf7', '123', 'parent', '', 'yes', '2022-12-07 11:10:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (47, 124, 'std124', 'vlubrl', '', 'student', '', 'yes', '2022-12-07 11:10:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (48, 0, 'parent124', 'qijt5n', '124', 'parent', '', 'yes', '2022-12-07 11:10:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (49, 125, 'std125', '63gdgi', '', 'student', '', 'yes', '2022-12-07 11:14:07', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (50, 0, 'parent125', 'npqr6v', '125', 'parent', '', 'yes', '2022-12-07 11:14:07', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (51, 126, 'std126', 'isgcwu', '', 'student', '', 'yes', '2022-12-07 11:20:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (52, 0, 'parent126', 'y6fr2p', '126', 'parent', '', 'yes', '2022-12-07 11:20:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (53, 127, 'std127', 'p4rd1i', '', 'student', '', 'yes', '2022-12-07 11:30:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (54, 0, 'parent127', 'kvo7od', '127', 'parent', '', 'yes', '2022-12-07 11:30:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (55, 128, 'std128', 'r4fmk5', '', 'student', '', 'yes', '2022-12-07 11:35:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (56, 0, 'parent128', '642k4i', '128', 'parent', '', 'yes', '2022-12-07 11:35:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (57, 129, 'std129', 'eifker', '', 'student', '', 'yes', '2022-12-07 11:39:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (58, 0, 'parent129', 'izep9l', '129', 'parent', '', 'yes', '2022-12-07 11:39:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (59, 130, 'std130', 'tmkofm', '', 'student', '', 'yes', '2022-12-07 11:39:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (60, 0, 'parent130', 'p6y83b', '130', 'parent', '', 'yes', '2022-12-07 11:39:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (61, 131, 'std131', 'r8x1bp', '', 'student', '', 'yes', '2022-12-07 11:42:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (62, 0, 'parent131', '0jjbbc', '131', 'parent', '', 'yes', '2022-12-07 11:42:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (63, 132, 'std132', '47yfrw', '', 'student', '', 'yes', '2022-12-07 11:48:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (64, 0, 'parent132', 'aftpdj', '132', 'parent', '', 'yes', '2022-12-07 11:48:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (65, 133, 'std133', 'c928tf', '', 'student', '', 'yes', '2022-12-07 11:49:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (66, 0, 'parent133', '93cv17', '133', 'parent', '', 'yes', '2022-12-07 11:49:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (67, 134, 'std134', '5q5zey', '', 'student', '', 'yes', '2022-12-07 11:54:48', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (68, 0, 'parent134', '5f958p', '134', 'parent', '', 'yes', '2022-12-07 11:54:48', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (69, 135, 'std135', '3rhzbf', '', 'student', '', 'yes', '2022-12-07 11:59:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (70, 0, 'parent135', 'dj93y0', '135', 'parent', '', 'yes', '2022-12-07 11:59:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (71, 136, 'std136', '83pkzh', '', 'student', '', 'yes', '2022-12-07 12:05:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (72, 0, 'parent136', 'y9za3k', '136', 'parent', '', 'yes', '2022-12-07 12:05:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (73, 137, 'std137', 'idxglh', '', 'student', '', 'yes', '2022-12-07 12:07:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (74, 0, 'parent137', 'sph3ki', '137', 'parent', '', 'yes', '2022-12-07 12:07:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (75, 138, 'std138', 't4kpw1', '', 'student', '', 'yes', '2022-12-07 12:22:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (76, 0, 'parent138', 'rnfhu2', '138', 'parent', '', 'yes', '2022-12-07 12:22:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (77, 139, 'std139', 'iuds8r', '', 'student', '', 'yes', '2022-12-07 12:31:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (78, 0, 'parent139', 'sjmn0o', '139', 'parent', '', 'yes', '2022-12-07 12:31:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (79, 140, 'std140', 'chsq8j', '', 'student', '', 'yes', '2022-12-07 12:41:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (80, 0, 'parent140', 'kc6wpg', '140', 'parent', '', 'yes', '2022-12-07 12:41:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (81, 141, 'std141', '7kynav', '', 'student', '', 'yes', '2022-12-07 12:47:27', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (82, 0, 'parent141', 'jj07hi', '141', 'parent', '', 'yes', '2022-12-07 12:47:27', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (83, 142, 'std142', 'w48xs8', '', 'student', '', 'yes', '2022-12-07 12:50:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (84, 0, 'parent142', 'w56nf9', '142', 'parent', '', 'yes', '2022-12-07 12:50:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (85, 143, 'std143', '7v9g5b', '', 'student', '', 'yes', '2022-12-07 12:54:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (86, 0, 'parent143', '3hkx18', '143', 'parent', '', 'yes', '2022-12-07 12:54:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (87, 144, 'std144', '5qneen', '', 'student', '', 'yes', '2022-12-07 12:57:43', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (88, 0, 'parent144', 'rwppyz', '144', 'parent', '', 'yes', '2022-12-07 12:57:43', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (89, 145, 'std145', 'c8n4gm', '', 'student', '', 'yes', '2022-12-07 13:01:37', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (90, 0, 'parent145', '0mougk', '145', 'parent', '', 'yes', '2022-12-07 13:01:37', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (91, 146, 'std146', 'cuqikh', '', 'student', '', 'yes', '2022-12-07 13:04:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (92, 0, 'parent146', 'f6mn8x', '146', 'parent', '', 'yes', '2022-12-07 13:04:47', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (93, 147, 'std147', 'rreim9', '', 'student', '', 'yes', '2022-12-07 13:08:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (94, 0, 'parent147', 'aai7ah', '147', 'parent', '', 'yes', '2022-12-07 13:08:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (95, 148, 'std148', 't3k3fn', '', 'student', '', 'yes', '2022-12-07 13:12:37', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (96, 0, 'parent148', '4j4vqa', '148', 'parent', '', 'yes', '2022-12-07 13:12:37', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (97, 149, 'std149', 'atjcoo', '', 'student', '', 'yes', '2022-12-07 13:16:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (98, 0, 'parent149', 'mjpbqs', '149', 'parent', '', 'yes', '2022-12-07 13:16:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (99, 150, 'std150', 'genfhr', '', 'student', '', 'yes', '2022-12-07 13:24:13', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (100, 0, 'parent150', '4nla8b', '150', 'parent', '', 'yes', '2022-12-07 13:24:13', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (101, 151, 'std151', 'l5nkna', '', 'student', '', 'yes', '2022-12-07 13:29:08', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (102, 0, 'parent151', 'tw6saa', '151', 'parent', '', 'yes', '2022-12-07 13:29:08', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (103, 152, 'std152', 'v3ut35', '', 'student', '', 'yes', '2022-12-07 13:32:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (104, 0, 'parent152', '0zb8fc', '152', 'parent', '', 'yes', '2022-12-07 13:32:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (105, 153, 'std153', 'rauffl', '', 'student', '', 'yes', '2022-12-07 13:45:15', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (106, 0, 'parent153', 'tkjuqj', '153', 'parent', '', 'yes', '2022-12-07 13:45:15', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (107, 154, 'std154', 'azrjk5', '', 'student', '', 'yes', '2022-12-07 13:51:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (108, 0, 'parent154', 'c9f880', '154', 'parent', '', 'yes', '2022-12-07 13:51:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (109, 155, 'std155', '2i609g', '', 'student', '', 'yes', '2022-12-07 13:55:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (110, 0, 'parent155', 'ulnx32', '155', 'parent', '', 'yes', '2022-12-07 13:55:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (111, 156, 'std156', 'qsdgu9', '', 'student', '', 'yes', '2022-12-07 13:56:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (112, 0, 'parent156', 'plct8r', '156', 'parent', '', 'yes', '2022-12-07 13:56:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (113, 157, 'std157', 'uhbh5m', '', 'student', '', 'yes', '2022-12-07 14:00:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (114, 0, 'parent157', 'jgz12v', '157', 'parent', '', 'yes', '2022-12-07 14:00:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (115, 158, 'std158', 'zbu29t', '', 'student', '', 'yes', '2022-12-07 14:06:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (116, 0, 'parent158', 'iuofwr', '158', 'parent', '', 'yes', '2022-12-07 14:06:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (117, 159, 'std159', 'c8p2hz', '', 'student', '', 'yes', '2022-12-07 14:08:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (118, 0, 'parent159', 'boy0z8', '159', 'parent', '', 'yes', '2022-12-07 14:08:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (119, 160, 'std160', 'wtki04', '', 'student', '', 'yes', '2022-12-07 14:13:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (120, 0, 'parent160', 's848eb', '160', 'parent', '', 'yes', '2022-12-07 14:13:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (121, 161, 'std161', 'vis6nl', '', 'student', '', 'yes', '2022-12-07 14:19:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (122, 0, 'parent161', 'oufror', '161', 'parent', '', 'yes', '2022-12-07 14:19:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (123, 162, 'std162', 'eku797', '', 'student', '', 'yes', '2022-12-07 14:24:00', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (124, 0, 'parent162', 'jb1dek', '162', 'parent', '', 'yes', '2022-12-07 14:24:00', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (125, 163, 'std163', '3jjkui', '', 'student', '', 'yes', '2022-12-07 14:24:18', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (126, 0, 'parent163', 'vm3pbw', '163', 'parent', '', 'yes', '2022-12-07 14:24:18', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (127, 164, 'std164', '86cz99', '', 'student', '', 'yes', '2022-12-07 14:30:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (128, 0, 'parent164', 'xun5qg', '164', 'parent', '', 'yes', '2022-12-07 14:30:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (129, 165, 'std165', '56ivpv', '', 'student', '', 'yes', '2022-12-07 14:34:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (130, 0, 'parent165', 'jveoqb', '165', 'parent', '', 'yes', '2022-12-07 14:34:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (131, 166, 'std166', 'g6yz49', '', 'student', '', 'yes', '2022-12-07 14:34:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (132, 0, 'parent166', '3cfe0l', '166', 'parent', '', 'yes', '2022-12-07 14:34:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (133, 167, 'std167', 'ka6jfy', '', 'student', '', 'yes', '2022-12-07 14:39:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (134, 0, 'parent167', '0seto7', '167', 'parent', '', 'yes', '2022-12-07 14:39:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (135, 168, 'std168', 'ch6ib5', '', 'student', '', 'yes', '2022-12-07 14:43:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (136, 0, 'parent168', '5mlihi', '168', 'parent', '', 'yes', '2022-12-07 14:43:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (137, 169, 'std169', 'qhnkip', '', 'student', '', 'yes', '2022-12-07 14:47:39', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (138, 0, 'parent169', 'voxbq9', '169', 'parent', '', 'yes', '2022-12-07 14:47:39', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (139, 170, 'std170', 'o4jwnf', '', 'student', '', 'yes', '2022-12-07 14:52:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (140, 0, 'parent170', 'hitapj', '170', 'parent', '', 'yes', '2022-12-07 14:52:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (141, 171, 'std171', '4zr7hl', '', 'student', '', 'yes', '2022-12-07 14:56:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (142, 0, 'parent171', 'worh40', '171', 'parent', '', 'yes', '2022-12-07 14:56:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (143, 172, 'std172', 'yk8pbu', '', 'student', '', 'yes', '2022-12-07 15:01:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (144, 0, 'parent172', 'z38r5f', '172', 'parent', '', 'yes', '2022-12-07 15:01:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (145, 173, 'std173', '47droj', '', 'student', '', 'yes', '2022-12-07 15:05:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (146, 0, 'parent173', 'pmdife', '173', 'parent', '', 'yes', '2022-12-07 15:05:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (147, 174, 'std174', 'kke1s4', '', 'student', '', 'yes', '2022-12-07 15:08:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (148, 0, 'parent174', 'x6mjp2', '174', 'parent', '', 'yes', '2022-12-07 15:08:26', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (149, 175, 'std175', 'f9u5eq', '', 'student', '', 'yes', '2022-12-07 15:13:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (150, 0, 'parent175', '1imde4', '175', 'parent', '', 'yes', '2022-12-07 15:13:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (151, 176, 'std176', 'vwoikq', '', 'student', '', 'yes', '2022-12-07 15:14:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (152, 0, 'parent176', '4u4rp2', '176', 'parent', '', 'yes', '2022-12-07 15:14:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (153, 177, 'std177', 'abece8', '', 'student', '', 'yes', '2022-12-07 15:17:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (154, 0, 'parent177', 'gududu', '177', 'parent', '', 'yes', '2022-12-07 15:17:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (155, 178, 'std178', 'ihpsxo', '', 'student', '', 'yes', '2022-12-07 15:20:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (156, 0, 'parent178', 'jsrv4p', '178', 'parent', '', 'yes', '2022-12-07 15:20:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (157, 179, 'std179', '4yod7h', '', 'student', '', 'yes', '2022-12-07 15:28:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (158, 0, 'parent179', '24s3zj', '179', 'parent', '', 'yes', '2022-12-07 15:28:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (159, 180, 'std180', 'oyp4c2', '', 'student', '', 'yes', '2022-12-07 15:31:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (160, 0, 'parent180', 'muxrdp', '180', 'parent', '', 'yes', '2022-12-07 15:31:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (161, 181, 'std181', 'p8ckj1', '', 'student', '', 'yes', '2022-12-07 15:33:57', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (162, 0, 'parent181', 'jwb9ty', '181', 'parent', '', 'yes', '2022-12-07 15:33:57', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (163, 182, 'std182', 'ulb064', '', 'student', '', 'yes', '2022-12-07 15:36:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (164, 0, 'parent182', '04v64s', '182', 'parent', '', 'yes', '2022-12-07 15:36:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (165, 183, 'std183', 'ko2ntf', '', 'student', '', 'yes', '2022-12-07 15:40:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (166, 0, 'parent183', 'ao1twa', '183', 'parent', '', 'yes', '2022-12-07 15:40:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (167, 184, 'std184', 'o36odg', '', 'student', '', 'yes', '2022-12-07 15:40:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (168, 0, 'parent184', 'awy57x', '184', 'parent', '', 'yes', '2022-12-07 15:40:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (169, 185, 'std185', 'zkneaz', '', 'student', '', 'yes', '2022-12-07 15:43:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (170, 0, 'parent185', 'h5yjp7', '185', 'parent', '', 'yes', '2022-12-07 15:43:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (171, 186, 'std186', 'x7e4vg', '', 'student', '', 'yes', '2022-12-07 16:11:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (172, 0, 'parent186', 'npmpl7', '186', 'parent', '', 'yes', '2022-12-07 16:11:34', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (173, 187, 'std187', 'jvk0em', '', 'student', '', 'yes', '2022-12-07 16:15:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (174, 0, 'parent187', '4dr7rc', '187', 'parent', '', 'yes', '2022-12-07 16:15:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (175, 188, 'std188', 'zhdfuk', '', 'student', '', 'yes', '2022-12-07 16:20:28', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (176, 0, 'parent188', 'n2mozf', '188', 'parent', '', 'yes', '2022-12-07 16:20:28', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (177, 189, 'std189', '7vl8z0', '', 'student', '', 'yes', '2022-12-07 16:24:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (178, 0, 'parent189', '7syfu8', '189', 'parent', '', 'yes', '2022-12-07 16:24:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (179, 190, 'std190', '83epgp', '', 'student', '', 'yes', '2022-12-07 16:28:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (180, 0, 'parent190', 'btvq70', '190', 'parent', '', 'yes', '2022-12-07 16:28:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (181, 191, 'std191', 'p8s7dv', '', 'student', '', 'yes', '2022-12-07 16:32:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (182, 0, 'parent191', 'q1z7kr', '191', 'parent', '', 'yes', '2022-12-07 16:32:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (183, 192, 'std192', 'ea179k', '', 'student', '', 'yes', '2022-12-07 16:36:07', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (184, 0, 'parent192', 'q7aerd', '192', 'parent', '', 'yes', '2022-12-07 16:36:07', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (185, 193, 'std193', 'ubygel', '', 'student', '', 'yes', '2022-12-07 16:45:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (186, 0, 'parent193', 'nuodgl', '193', 'parent', '', 'yes', '2022-12-07 16:45:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (187, 194, 'std194', '2qbrt8', '', 'student', '', 'yes', '2022-12-07 16:46:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (188, 0, 'parent194', 'ywus7g', '194', 'parent', '', 'yes', '2022-12-07 16:46:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (189, 195, 'std195', '9mmdlb', '', 'student', '', 'yes', '2022-12-07 17:00:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (190, 0, 'parent195', 'i81fzf', '195', 'parent', '', 'yes', '2022-12-07 17:00:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (191, 196, 'std196', 'lbu61j', '', 'student', '', 'yes', '2022-12-07 17:04:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (192, 0, 'parent196', 'prb8ty', '196', 'parent', '', 'yes', '2022-12-07 17:04:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (193, 197, 'std197', 'rb80eh', '', 'student', '', 'yes', '2022-12-07 17:07:40', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (194, 0, 'parent197', 'p64uqt', '197', 'parent', '', 'yes', '2022-12-07 17:07:40', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (195, 198, 'std198', '5358gt', '', 'student', '', 'yes', '2022-12-07 17:10:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (196, 0, 'parent198', 'qaaxtm', '198', 'parent', '', 'yes', '2022-12-07 17:10:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (197, 199, 'std199', '2govgv', '', 'student', '', 'yes', '2022-12-07 17:13:55', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (198, 0, 'parent199', 'isspgi', '199', 'parent', '', 'yes', '2022-12-07 17:13:55', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (199, 200, 'std200', 'y2c8hl', '', 'student', '', 'yes', '2022-12-07 17:18:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (200, 0, 'parent200', 'uthbna', '200', 'parent', '', 'yes', '2022-12-07 17:18:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (201, 201, 'std201', 'wpoyiq', '', 'student', '', 'yes', '2022-12-07 23:05:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (202, 0, 'parent201', 'oh1ylq', '201', 'parent', '', 'yes', '2022-12-07 23:05:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (203, 202, 'std202', '91o6x0', '', 'student', '', 'yes', '2022-12-07 23:10:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (204, 0, 'parent202', '5hb7ta', '202', 'parent', '', 'yes', '2022-12-07 23:10:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (205, 203, 'std203', '9s5gml', '', 'student', '', 'yes', '2022-12-07 23:14:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (206, 0, 'parent203', 'n0jos9', '203', 'parent', '', 'yes', '2022-12-07 23:14:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (207, 204, 'std204', 'g4a0me', '', 'student', '', 'yes', '2022-12-07 23:15:40', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (208, 0, 'parent204', 'g8qz2m', '204', 'parent', '', 'yes', '2022-12-07 23:15:40', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (209, 205, 'std205', 'nch0e2', '', 'student', '', 'yes', '2022-12-07 23:18:28', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (210, 0, 'parent205', 'slsd6k', '205', 'parent', '', 'yes', '2022-12-07 23:18:28', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (211, 206, 'std206', 'kbwrpa', '', 'student', '', 'yes', '2022-12-07 23:22:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (212, 0, 'parent206', 'gzjopq', '206', 'parent', '', 'yes', '2022-12-07 23:22:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (213, 207, 'std207', '6m7h1q', '', 'student', '', 'yes', '2022-12-07 23:22:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (214, 0, 'parent207', 'u2oc2k', '207', 'parent', '', 'yes', '2022-12-07 23:22:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (215, 208, 'std208', '74so54', '', 'student', '', 'yes', '2022-12-07 23:27:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (216, 0, 'parent208', '7i3kp7', '208', 'parent', '', 'yes', '2022-12-07 23:27:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (217, 209, 'std209', 'sbs7pa', '', 'student', '', 'yes', '2022-12-07 23:30:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (218, 0, 'parent209', 'nhixbx', '209', 'parent', '', 'yes', '2022-12-07 23:30:49', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (219, 210, 'std210', 'lqe93p', '', 'student', '', 'yes', '2022-12-07 23:34:41', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (220, 0, 'parent210', 's5je87', '210', 'parent', '', 'yes', '2022-12-07 23:34:41', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (221, 211, 'std211', 'jlyp4m', '', 'student', '', 'yes', '2022-12-07 23:35:00', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (222, 0, 'parent211', '5w5hav', '211', 'parent', '', 'yes', '2022-12-07 23:35:00', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (223, 212, 'std212', 'wpsoez', '', 'student', '', 'yes', '2022-12-07 23:39:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (224, 0, 'parent212', '25qhwy', '212', 'parent', '', 'yes', '2022-12-07 23:39:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (225, 213, 'std213', 't79lzq', '', 'student', '', 'yes', '2022-12-07 23:43:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (226, 0, 'parent213', 's9r675', '213', 'parent', '', 'yes', '2022-12-07 23:43:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (227, 214, 'std214', 'ape1po', '', 'student', '', 'yes', '2022-12-07 23:44:32', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (228, 0, 'parent214', '4xn83m', '214', 'parent', '', 'yes', '2022-12-07 23:44:32', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (229, 215, 'std215', '9nmtbe', '', 'student', '', 'yes', '2022-12-07 23:47:55', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (230, 0, 'parent215', 'ox0d2c', '215', 'parent', '', 'yes', '2022-12-07 23:47:55', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (231, 216, 'std216', 'a7axaw', '', 'student', '', 'yes', '2022-12-07 23:52:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (232, 0, 'parent216', 'ci1hbl', '216', 'parent', '', 'yes', '2022-12-07 23:52:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (233, 217, 'std217', 'yx12n9', '', 'student', '', 'yes', '2022-12-07 23:53:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (234, 0, 'parent217', 'r0j4qt', '217', 'parent', '', 'yes', '2022-12-07 23:53:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (235, 218, 'std218', 'ruub1c', '', 'student', '', 'yes', '2022-12-07 23:56:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (236, 0, 'parent218', '57b943', '218', 'parent', '', 'yes', '2022-12-07 23:56:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (237, 219, 'std219', 'adbfvo', '', 'student', '', 'yes', '2022-12-08 00:01:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (238, 0, 'parent219', 'cv5c8w', '219', 'parent', '', 'yes', '2022-12-08 00:01:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (239, 220, 'std220', 'g9u5q1', '', 'student', '', 'yes', '2022-12-08 00:02:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (240, 0, 'parent220', '8xhm9q', '220', 'parent', '', 'yes', '2022-12-08 00:02:56', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (241, 221, 'std221', 'y3tlj7', '', 'student', '', 'yes', '2022-12-08 00:07:12', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (242, 0, 'parent221', 'j37mz6', '221', 'parent', '', 'yes', '2022-12-08 00:07:12', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (243, 222, 'std222', '7zjarr', '', 'student', '', 'yes', '2022-12-08 00:11:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (244, 0, 'parent222', 'q3wgxb', '222', 'parent', '', 'yes', '2022-12-08 00:11:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (245, 223, 'std223', '6h7l42', '', 'student', '', 'yes', '2022-12-08 00:15:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (246, 0, 'parent223', 'oe4cdn', '223', 'parent', '', 'yes', '2022-12-08 00:15:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (247, 224, 'std224', 'azkal8', '', 'student', '', 'yes', '2022-12-08 00:28:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (248, 0, 'parent224', 'xfgon9', '224', 'parent', '', 'yes', '2022-12-08 00:28:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (249, 225, 'std225', '3hgpkl', '', 'student', '', 'yes', '2022-12-08 00:30:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (250, 0, 'parent225', 'ra9ndw', '225', 'parent', '', 'yes', '2022-12-08 00:30:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (251, 226, 'std226', 'wcz9zr', '', 'student', '', 'yes', '2022-12-08 00:33:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (252, 0, 'parent226', 'ndulce', '226', 'parent', '', 'yes', '2022-12-08 00:33:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (253, 227, 'std227', '5h8qa5', '', 'student', '', 'yes', '2022-12-08 00:38:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (254, 0, 'parent227', 'c606gl', '227', 'parent', '', 'yes', '2022-12-08 00:38:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (255, 228, 'std228', '77bxon', '', 'student', '', 'yes', '2022-12-08 00:41:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (256, 0, 'parent228', 'qwg40a', '228', 'parent', '', 'yes', '2022-12-08 00:41:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (257, 229, 'std229', 'mx73xg', '', 'student', '', 'yes', '2022-12-08 00:42:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (258, 0, 'parent229', 'tnubf6', '229', 'parent', '', 'yes', '2022-12-08 00:42:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (259, 230, 'std230', '70srsd', '', 'student', '', 'yes', '2022-12-08 00:47:15', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (260, 0, 'parent230', '4306a1', '230', 'parent', '', 'yes', '2022-12-08 00:47:15', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (261, 231, 'std231', 'u2mqhg', '', 'student', '', 'yes', '2022-12-08 00:50:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (262, 0, 'parent231', 'r388c9', '231', 'parent', '', 'yes', '2022-12-08 00:50:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (263, 232, 'std232', 's4q2li', '', 'student', '', 'yes', '2022-12-08 00:53:35', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (264, 0, 'parent232', 'spzd3z', '232', 'parent', '', 'yes', '2022-12-08 00:53:35', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (265, 233, 'std233', 'ex70qa', '', 'student', '', 'yes', '2022-12-08 00:56:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (266, 0, 'parent233', 'uo2ekg', '233', 'parent', '', 'yes', '2022-12-08 00:56:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (267, 234, 'std234', 'p5c9fh', '', 'student', '', 'yes', '2022-12-08 01:00:22', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (268, 0, 'parent234', 's6vbw2', '234', 'parent', '', 'yes', '2022-12-08 01:00:22', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (269, 235, 'std235', 'foxglu', '', 'student', '', 'yes', '2022-12-08 01:03:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (270, 0, 'parent235', 'erhv47', '235', 'parent', '', 'yes', '2022-12-08 01:03:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (271, 236, 'std236', 'diwh8w', '', 'student', '', 'yes', '2022-12-08 01:05:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (272, 0, 'parent236', 'taed8m', '236', 'parent', '', 'yes', '2022-12-08 01:05:17', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (273, 237, 'std237', 'ytncqt', '', 'student', '', 'yes', '2022-12-08 01:08:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (274, 0, 'parent237', 'r5afw0', '237', 'parent', '', 'yes', '2022-12-08 01:08:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (275, 238, 'std238', 'ftuyl6', '', 'student', '', 'yes', '2022-12-08 01:11:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (276, 0, 'parent238', '4a9bu4', '238', 'parent', '', 'yes', '2022-12-08 01:11:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (277, 239, 'std239', 'kqqj3h', '', 'student', '', 'yes', '2022-12-08 01:14:31', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (278, 0, 'parent239', 'zpfyzu', '239', 'parent', '', 'yes', '2022-12-08 01:14:31', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (279, 240, 'std240', '6wggj6', '', 'student', '', 'yes', '2022-12-08 01:15:03', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (280, 0, 'parent240', '2zstbr', '240', 'parent', '', 'yes', '2022-12-08 01:15:03', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (281, 241, 'std241', 'ay6bom', '', 'student', '', 'yes', '2022-12-08 01:17:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (282, 0, 'parent241', 'le60eh', '241', 'parent', '', 'yes', '2022-12-08 01:17:59', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (283, 242, 'std242', 'q0dwm6', '', 'student', '', 'yes', '2022-12-08 01:21:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (284, 0, 'parent242', 'g5uvx0', '242', 'parent', '', 'yes', '2022-12-08 01:21:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (285, 243, 'std243', 'g0skqt', '', 'student', '', 'yes', '2022-12-08 01:24:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (286, 0, 'parent243', 'bch6by', '243', 'parent', '', 'yes', '2022-12-08 01:24:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (287, 244, 'std244', 'taudea', '', 'student', '', 'yes', '2022-12-08 01:27:12', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (288, 0, 'parent244', 'g5t2sx', '244', 'parent', '', 'yes', '2022-12-08 01:27:12', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (289, 245, 'std245', 'h7q3e6', '', 'student', '', 'yes', '2022-12-08 01:40:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (290, 0, 'parent245', 'n7efzd', '245', 'parent', '', 'yes', '2022-12-08 01:40:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (291, 246, 'std246', 'zs943o', '', 'student', '', 'yes', '2022-12-08 01:46:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (292, 0, 'parent246', 'g9wx9o', '246', 'parent', '', 'yes', '2022-12-08 01:46:44', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (293, 247, 'std247', 'ccdlj3', '', 'student', '', 'yes', '2022-12-08 04:01:38', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (294, 0, 'parent247', '2m3owa', '247', 'parent', '', 'yes', '2022-12-08 04:01:38', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (295, 248, 'std248', 'pa932o', '', 'student', '', 'yes', '2022-12-08 11:26:18', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (296, 0, 'parent248', 'fkhipw', '248', 'parent', '', 'yes', '2022-12-08 11:26:18', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (297, 249, 'std249', 'n3rmaq', '', 'student', '', 'yes', '2022-12-08 11:35:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (298, 0, 'parent249', 'qhze0v', '249', 'parent', '', 'yes', '2022-12-08 11:35:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (299, 250, 'std250', 'qfzax9', '', 'student', '', 'yes', '2022-12-08 11:38:27', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (300, 0, 'parent250', '9jh2st', '250', 'parent', '', 'yes', '2022-12-08 11:38:27', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (301, 251, 'std251', 'fkhfil', '', 'student', '', 'yes', '2022-12-08 11:49:39', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (302, 0, 'parent251', 'jegd4s', '251', 'parent', '', 'yes', '2022-12-08 11:49:39', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (303, 252, 'std252', 'td7q2y', '', 'student', '', 'yes', '2022-12-08 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (304, 0, 'parent252', 'rd3u6s', '252', 'parent', '', 'yes', '2022-12-08 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (305, 253, 'std253', 'vn3fiu', '', 'student', '', 'yes', '2022-12-08 12:18:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (306, 0, 'parent253', 'jklpbq', '253', 'parent', '', 'yes', '2022-12-08 12:18:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (307, 254, 'std254', 'ewo5a5', '', 'student', '', 'yes', '2022-12-08 12:22:15', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (308, 0, 'parent254', '2cus3h', '254', 'parent', '', 'yes', '2022-12-08 12:22:15', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (309, 255, 'std255', 'jz9cun', '', 'student', '', 'yes', '2022-12-08 12:26:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (310, 0, 'parent255', 'vjxh2z', '255', 'parent', '', 'yes', '2022-12-08 12:26:50', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (311, 256, 'std256', '05urdk', '', 'student', '', 'yes', '2022-12-08 12:30:22', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (312, 0, 'parent256', 's4af33', '256', 'parent', '', 'yes', '2022-12-08 12:30:22', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (313, 257, 'std257', '66kv3k', '', 'student', '', 'yes', '2022-12-08 12:31:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (314, 0, 'parent257', 'qrsbt6', '257', 'parent', '', 'yes', '2022-12-08 12:31:14', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (315, 258, 'std258', 'k990x4', '', 'student', '', 'yes', '2022-12-08 12:34:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (316, 0, 'parent258', '1mkwuh', '258', 'parent', '', 'yes', '2022-12-08 12:34:45', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (317, 259, 'std259', 'sj60k8', '', 'student', '', 'yes', '2022-12-08 12:44:41', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (318, 0, 'parent259', 'lx0fg4', '259', 'parent', '', 'yes', '2022-12-08 12:44:41', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (319, 260, 'std260', 't5r9yt', '', 'student', '', 'yes', '2022-12-08 12:48:38', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (320, 0, 'parent260', '9mz07i', '260', 'parent', '', 'yes', '2022-12-08 12:48:38', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (321, 261, 'std261', 'haf9vn', '', 'student', '', 'yes', '2022-12-08 12:51:42', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (322, 0, 'parent261', 'tz45m8', '261', 'parent', '', 'yes', '2022-12-08 12:51:42', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (323, 262, 'std262', 'vbhj3v', '', 'student', '', 'yes', '2022-12-08 12:56:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (324, 0, 'parent262', '25g12y', '262', 'parent', '', 'yes', '2022-12-08 12:56:46', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (325, 263, 'std263', 'lolwa2', '', 'student', '', 'yes', '2022-12-08 13:00:03', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (326, 0, 'parent263', '05yzg9', '263', 'parent', '', 'yes', '2022-12-08 13:00:03', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (327, 264, 'std264', '3yhtd3', '', 'student', '', 'yes', '2022-12-08 13:02:36', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (328, 0, 'parent264', 'igonub', '264', 'parent', '', 'yes', '2022-12-08 13:02:36', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (329, 265, 'std265', 'qoqhtx', '', 'student', '', 'yes', '2022-12-08 13:05:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (330, 0, 'parent265', 'jcx4fa', '265', 'parent', '', 'yes', '2022-12-08 13:05:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (331, 266, 'std266', 'cpgvry', '', 'student', '', 'yes', '2022-12-08 13:09:08', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (332, 0, 'parent266', '1768ih', '266', 'parent', '', 'yes', '2022-12-08 13:09:08', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (333, 267, 'std267', 'yj5gar', '', 'student', '', 'yes', '2022-12-08 13:19:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (334, 0, 'parent267', 'syux43', '267', 'parent', '', 'yes', '2022-12-08 13:19:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (335, 268, 'std268', 'o65lsz', '', 'student', '', 'yes', '2022-12-08 13:21:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (336, 0, 'parent268', 'gif3js', '268', 'parent', '', 'yes', '2022-12-08 13:21:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (337, 269, 'std269', 'acm12t', '', 'student', '', 'yes', '2022-12-08 13:25:25', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (338, 0, 'parent269', 'ypiu45', '269', 'parent', '', 'yes', '2022-12-08 13:25:25', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (339, 270, 'std270', '3fvqd3', '', 'student', '', 'yes', '2022-12-08 13:28:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (340, 0, 'parent270', 'lw30t8', '270', 'parent', '', 'yes', '2022-12-08 13:28:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (341, 271, 'std271', 'ookv5r', '', 'student', '', 'yes', '2022-12-08 13:32:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (342, 0, 'parent271', 'v8m0iv', '271', 'parent', '', 'yes', '2022-12-08 13:32:04', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (343, 272, 'std272', 'ochj6k', '', 'student', '', 'yes', '2022-12-08 13:36:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (344, 0, 'parent272', 'xl5kpd', '272', 'parent', '', 'yes', '2022-12-08 13:36:05', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (345, 273, 'std273', '3bsb9b', '', 'student', '', 'yes', '2022-12-08 13:41:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (346, 0, 'parent273', 'p9ci5a', '273', 'parent', '', 'yes', '2022-12-08 13:41:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (347, 274, 'std274', 'u5gzl9', '', 'student', '', 'yes', '2022-12-08 13:46:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (348, 0, 'parent274', 'tvijz9', '274', 'parent', '', 'yes', '2022-12-08 13:46:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (349, 275, 'std275', 'uhfsfx', '', 'student', '', 'yes', '2022-12-08 13:47:55', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (350, 0, 'parent275', 'glb4z1', '275', 'parent', '', 'yes', '2022-12-08 13:47:55', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (351, 276, 'std276', 'mknwr9', '', 'student', '', 'yes', '2022-12-08 13:51:38', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (352, 0, 'parent276', 'dnujn0', '276', 'parent', '', 'yes', '2022-12-08 13:51:38', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (353, 277, 'std277', 'yayebq', '', 'student', '', 'yes', '2022-12-08 13:57:13', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (354, 0, 'parent277', 'xi90d9', '277', 'parent', '', 'yes', '2022-12-08 13:57:13', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (355, 278, 'std278', 'gh7e80', '', 'student', '', 'yes', '2022-12-08 14:00:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (356, 0, 'parent278', '78m7tx', '278', 'parent', '', 'yes', '2022-12-08 14:00:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (357, 279, 'std279', 'faks5k', '', 'student', '', 'yes', '2022-12-08 14:02:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (358, 0, 'parent279', 'rtqbrp', '279', 'parent', '', 'yes', '2022-12-08 14:02:20', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (359, 280, 'std280', '0j9y8w', '', 'student', '', 'yes', '2022-12-08 14:05:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (360, 0, 'parent280', 'vz6nv6', '280', 'parent', '', 'yes', '2022-12-08 14:05:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (361, 281, 'std281', '658im3', '', 'student', '', 'yes', '2022-12-08 14:09:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (362, 0, 'parent281', 'w3ew78', '281', 'parent', '', 'yes', '2022-12-08 14:09:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (363, 282, 'std282', '2okqa9', '', 'student', '', 'yes', '2022-12-08 14:12:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (364, 0, 'parent282', 's6pp36', '282', 'parent', '', 'yes', '2022-12-08 14:12:16', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (365, 283, 'std283', '1aahg3', '', 'student', '', 'yes', '2022-12-08 14:14:32', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (366, 0, 'parent283', 'ifpu7h', '283', 'parent', '', 'yes', '2022-12-08 14:14:32', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (367, 284, 'std284', '2hb92y', '', 'student', '', 'yes', '2022-12-08 14:14:39', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (368, 0, 'parent284', '8bpd5e', '284', 'parent', '', 'yes', '2022-12-08 14:14:39', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (369, 285, 'std285', 'w6meu2', '', 'student', '', 'yes', '2022-12-08 14:18:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (370, 0, 'parent285', '5ut3yb', '285', 'parent', '', 'yes', '2022-12-08 14:18:11', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (371, 286, 'std286', 'juhfcr', '', 'student', '', 'yes', '2022-12-08 14:20:25', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (372, 0, 'parent286', 'gfecxe', '286', 'parent', '', 'yes', '2022-12-08 14:20:25', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (373, 287, 'std287', 'ol480v', '', 'student', '', 'yes', '2022-12-08 14:26:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (374, 0, 'parent287', 'm65vgo', '287', 'parent', '', 'yes', '2022-12-08 14:26:58', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (375, 288, 'std288', 'l76y9y', '', 'student', '', 'yes', '2022-12-08 14:28:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (376, 0, 'parent288', '90l9fb', '288', 'parent', '', 'yes', '2022-12-08 14:28:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (377, 289, 'std289', 'f8mtvu', '', 'student', '', 'yes', '2022-12-08 14:29:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (378, 0, 'parent289', 'em8acw', '289', 'parent', '', 'yes', '2022-12-08 14:29:29', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (379, 290, 'std290', 'q63qbc', '', 'student', '', 'yes', '2022-12-08 14:29:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (380, 0, 'parent290', 'ogzuvd', '290', 'parent', '', 'yes', '2022-12-08 14:29:51', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (381, 291, 'std291', 'x5r685', '', 'student', '', 'yes', '2022-12-08 14:32:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (382, 0, 'parent291', 'engkvw', '291', 'parent', '', 'yes', '2022-12-08 14:32:23', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (383, 292, 'std292', 'szw7yz', '', 'student', '', 'yes', '2022-12-08 14:37:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (384, 0, 'parent292', 'qccf1b', '292', 'parent', '', 'yes', '2022-12-08 14:37:33', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (385, 293, 'std293', 'nicyrj', '', 'student', '', 'yes', '2022-12-08 14:42:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (386, 0, 'parent293', '9dh1km', '293', 'parent', '', 'yes', '2022-12-08 14:42:01', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (387, 294, 'std294', 'n7v5e5', '', 'student', '', 'yes', '2022-12-08 14:46:21', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (388, 0, 'parent294', '22sac0', '294', 'parent', '', 'yes', '2022-12-08 14:46:21', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (389, 295, 'std295', 'h135ta', '', 'student', '', 'yes', '2022-12-08 14:46:25', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (390, 0, 'parent295', '6c9mon', '295', 'parent', '', 'yes', '2022-12-08 14:46:25', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (391, 296, 'std296', 'gg8n95', '', 'student', '', 'yes', '2022-12-08 14:56:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (392, 0, 'parent296', 'sw7zqc', '296', 'parent', '', 'yes', '2022-12-08 14:56:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (393, 297, 'std297', '6cwgya', '', 'student', '', 'yes', '2022-12-09 00:50:32', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (394, 0, 'parent297', 'k4946g', '297', 'parent', '', 'yes', '2022-12-09 00:50:32', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (395, 298, 'std298', 'sho48g', '', 'student', '', 'yes', '2022-12-09 01:01:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (396, 0, 'parent298', '4uim2r', '298', 'parent', '', 'yes', '2022-12-09 01:01:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (397, 299, 'std299', 'hihc0t', '', 'student', '', 'yes', '2022-12-09 01:10:37', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (398, 0, 'parent299', 'wx7ldw', '299', 'parent', '', 'yes', '2022-12-09 01:10:37', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (399, 300, 'std300', 'a7p32b', '', 'student', '', 'yes', '2022-12-09 05:03:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (400, 0, 'parent300', '67lotl', '300', 'parent', '', 'yes', '2022-12-09 05:03:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (401, 301, 'std301', '1mwgu6', '', 'student', '', 'yes', '2022-12-09 05:11:42', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (402, 0, 'parent301', 'mp3p9g', '301', 'parent', '', 'yes', '2022-12-09 05:11:42', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (403, 302, 'std302', 'y8ml4x', '', 'student', '', 'yes', '2022-12-09 05:16:43', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (404, 0, 'parent302', 'ut4yvu', '302', 'parent', '', 'yes', '2022-12-09 05:16:43', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (405, 303, 'std303', 'j38kys', '', 'student', '', 'yes', '2022-12-09 05:22:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (406, 0, 'parent303', 'pyuzlx', '303', 'parent', '', 'yes', '2022-12-09 05:22:54', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (407, 304, 'std304', '2ich8n', '', 'student', '', 'yes', '2022-12-09 05:27:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (408, 0, 'parent304', '10ta6z', '304', 'parent', '', 'yes', '2022-12-09 05:27:10', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (409, 305, 'std305', '3bbnku', '', 'student', '', 'yes', '2022-12-09 05:33:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (410, 0, 'parent305', 'fj9lqh', '305', 'parent', '', 'yes', '2022-12-09 05:33:24', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (411, 306, 'std306', 'l18xbn', '', 'student', '', 'yes', '2022-12-09 05:38:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (412, 0, 'parent306', 'r9t7gx', '306', 'parent', '', 'yes', '2022-12-09 05:38:30', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (413, 307, 'std307', '3hd3lm', '', 'student', '', 'yes', '2022-12-09 06:31:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (414, 0, 'parent307', 'hiawxr', '307', 'parent', '', 'yes', '2022-12-09 06:31:06', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (415, 308, 'std308', 'ivfjja', '', 'student', '', 'yes', '2022-12-09 06:34:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (416, 0, 'parent308', '6e5ezv', '308', 'parent', '', 'yes', '2022-12-09 06:34:19', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (417, 309, 'std309', '3dkgtk', '', 'student', '', 'yes', '2022-12-09 06:41:03', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (418, 0, 'parent309', 'ikraz1', '309', 'parent', '', 'yes', '2022-12-09 06:41:03', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (419, 310, 'std310', 'i2urc5', '', 'student', '', 'yes', '2022-12-09 07:13:03', '0000-00-00 00:00:00');
INSERT INTO `users` (`id`, `user_id`, `username`, `password`, `childs`, `role`, `verification_code`, `is_active`, `created_at`, `updated_at`) VALUES (420, 0, 'parent310', '3vlas7', '310', 'parent', '', 'yes', '2022-12-09 07:13:03', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: vehicle_routes
#

DROP TABLE IF EXISTS `vehicle_routes`;

CREATE TABLE `vehicle_routes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `route_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: vehicles
#

DROP TABLE IF EXISTS `vehicles`;

CREATE TABLE `vehicles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `vehicle_no` varchar(20) DEFAULT NULL,
  `vehicle_model` varchar(100) NOT NULL DEFAULT 'None',
  `manufacture_year` varchar(4) DEFAULT NULL,
  `driver_name` varchar(50) DEFAULT NULL,
  `driver_licence` varchar(50) NOT NULL DEFAULT 'None',
  `driver_contact` varchar(20) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: visitors_book
#

DROP TABLE IF EXISTS `visitors_book`;

CREATE TABLE `visitors_book` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source` varchar(100) DEFAULT NULL,
  `purpose` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `contact` varchar(12) NOT NULL,
  `id_proof` varchar(50) NOT NULL,
  `no_of_pepple` int(11) NOT NULL,
  `date` date NOT NULL,
  `in_time` varchar(20) NOT NULL,
  `out_time` varchar(20) NOT NULL,
  `note` mediumtext NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: visitors_purpose
#

DROP TABLE IF EXISTS `visitors_purpose`;

CREATE TABLE `visitors_purpose` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `visitors_purpose` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

